using System;
using System.Data;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

namespace gov.va.med.vbecs.BOL
{
	/// <summary>
	/// Summary description for SpecimenTest.
	/// </summary>
	public class SpecimenTest : BaseBusinessObject
	{
		private System.Data.DataTable _specimenTestTable;
		private System.Data.DataRow _specimenTestRow;
		private BOL.OrderedTest _orderedTest;
		private BOL.TestingMethod _testingMethod;
		private BOL.Rack _rack;
		private BOL.BloodTestType _bloodTestType;
		private BOL.TestResult _testResult;
		private BOL.AntibodyType _antibodyType;

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/28/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2826"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>SpecimenTest object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2830"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Constructor
		/// </summary>
		public SpecimenTest()
		{
			this._specimenTestTable = BOL.SpecimenTest.InitializeSpecimenTestTable(false);
			this._specimenTestRow = this._specimenTestTable.NewRow();
			this._specimenTestTable.Rows.Add(this._specimenTestRow);
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/28/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2835"> 
		///		<ExpectedInput>DataRow</ExpectedInput>
		///		<ExpectedOutput>SpecimenTest object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2840"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// ctor
		/// </summary>
		/// <param name="specimenTestRow"></param>
		public SpecimenTest(System.Data.DataRow specimenTestRow)
		{
			this.LoadFromDataRow(specimenTestRow);
			this._specimenTestTable = specimenTestRow.Table;
			this._specimenTestTable.AcceptChanges();
			//
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/28/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2841"> 
		///		<ExpectedInput>Guid</ExpectedInput>
		///		<ExpectedOutput>Guid</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2842"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// SpecimenTestGuid
		/// </summary>
		public Guid SpecimenTestGuid
		{
			get
			{
				if (this._specimenTestRow.IsNull(TABLE.SpecimenTest.SpecimenTestGuid))
				{
					return Guid.Empty;
				}
				return (Guid)_specimenTestRow[TABLE.SpecimenTest.SpecimenTestGuid];
			}
			set
			{
				this._specimenTestRow[TABLE.SpecimenTest.SpecimenTestGuid] = value;
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/28/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2843"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2856"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// DivisionCode
		/// </summary>
		public string DivisionCode
		{
			get
			{
				if (this._specimenTestRow.IsNull(TABLE.SpecimenTest.DivisionCode))
				{
					return string.Empty;
				}
				return (string)_specimenTestRow[TABLE.SpecimenTest.DivisionCode];
			}
			set
			{
				this._specimenTestRow[TABLE.SpecimenTest.DivisionCode] = value;
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/28/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2857"> 
		///		<ExpectedInput>BOL.OrderedTest</ExpectedInput>
		///		<ExpectedOutput>BOL.OrderedTest</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2859"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// OrderedTest
		/// </summary>
		public BOL.OrderedTest OrderedTest
		{
			get
			{
				return this._orderedTest;
			}
			set
			{
				this._orderedTest = value;
			}
		}
		

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/28/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2863"> 
		///		<ExpectedInput>BOL.TestingMethod</ExpectedInput>
		///		<ExpectedOutput>BOL.TestingMethod</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2868"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// TestingMethod
		/// </summary>
		public BOL.TestingMethod TestingMethod
		{
			get
			{
				return this._testingMethod;
			}
			set
			{
				this._testingMethod = value;
			}
		}


		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/28/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2876"> 
		///		<ExpectedInput>BOL.Rack</ExpectedInput>
		///		<ExpectedOutput>BOL.Rack</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2881"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Rack
		/// </summary>
		public BOL.Rack Rack
		{
			get
			{
				return this._rack;
			}
			set
			{
				this._rack = value;
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/28/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2882"> 
		///		<ExpectedInput>BOL.BloodTestType</ExpectedInput>
		///		<ExpectedOutput>BOL.BloodTestType</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2922"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// BloodTestType
		/// </summary>
		public BOL.BloodTestType BloodTestType
		{
			get
			{
				return this._bloodTestType;
			}
			set
			{
				this._bloodTestType = value;
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/28/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2923"> 
		///		<ExpectedInput>BOL.TestResult</ExpectedInput>
		///		<ExpectedOutput>BOL.TestResult</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2931"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// TestResult
		/// </summary>
		public BOL.TestResult TestResult
		{
			get
			{
				return this._testResult;
			}
			set
			{
				this._testResult = value;
			}
		}

		
		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/28/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2934"> 
		///		<ExpectedInput>BOL.AntibodyType</ExpectedInput>
		///		<ExpectedOutput>BOL.AntibodyType</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2935"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// AntibodyType
		/// </summary>
		public BOL.AntibodyType AntibodyType
		{
			get
			{
				return this._antibodyType;
			}
			set
			{
				this._antibodyType = value;
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/28/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2936"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2937"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// TestComments
		/// </summary>
		public string TestComments
		{
			get
			{
				return this._specimenTestRow[TABLE.SpecimenTest.TestComments].ToString();
			}
			set
			{
				this._specimenTestRow[TABLE.SpecimenTest.TestComments] = value;
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/28/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2938"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2939"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// AutoInstrumentName
		/// </summary>
		public string AutoInstrumentName
		{
			get
			{
				return this._specimenTestRow[TABLE.SpecimenTest.AutoInstrumentName].ToString();
			}
			set
			{
				this._specimenTestRow[TABLE.SpecimenTest.AutoInstrumentName] = value;
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/28/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2940"> 
		///		<ExpectedInput>Date</ExpectedInput>
		///		<ExpectedOutput>Date</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2943"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// TestDate
		/// </summary>
		public DateTime TestDate
		{
			get
			{
				return Convert.ToDateTime(this._specimenTestRow[TABLE.SpecimenTest.TestDate]);
			}
			set
			{
				this._specimenTestRow[TABLE.SpecimenTest.TestDate] = value;
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/28/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2944"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2945"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// TestTechId
		/// </summary>
		public string TestTechId
		{
			get
			{
				return this._specimenTestRow[TABLE.SpecimenTest.TestTechId].ToString();
			}
			set
			{
				this._specimenTestRow[TABLE.SpecimenTest.TestTechId] = value;
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/28/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2946"> 
		///		<ExpectedInput>bool</ExpectedInput>
		///		<ExpectedOutput>bool</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2947"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// AboRHChangeIndicator
		/// </summary>
		public bool AboRHChangeIndicator
		{
			get
			{
				if (this._specimenTestRow.IsNull(TABLE.SpecimenTest.AboRhChangeIndicator))
				{
					return false;
				}
				return Convert.ToBoolean(_specimenTestRow[TABLE.SpecimenTest.AboRhChangeIndicator]);
			}
			set
			{
				this._specimenTestRow[TABLE.SpecimenTest.AboRhChangeIndicator] = value;
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/28/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2827"> 
		///		<ExpectedInput>False</ExpectedInput>
		///		<ExpectedOutput>SpecimenTest DataTable</ExpectedOutput>
		///	</Case>
		///	
		///	
		///<Case type="0" testid ="6873"> 
		///		<ExpectedInput>True</ExpectedInput>
		///		<ExpectedOutput>SpecimenTest DataTable</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2948"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Creates an empty SpecimenTest table
		/// </summary>
		/// <returns></returns>
		public static DataTable InitializeSpecimenTestTable(bool update)
		{
			DataTable dtSpecimenTest = null;

			if (update == false)
			{
				dtSpecimenTest = new DataTable("SpecimenTestInsert");
			}
			else
			{
				dtSpecimenTest = new DataTable("SpecimenTestUpdate");
			}

			if (update == false)
			{
				dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.OrderedTestGuid, typeof(Guid));
				dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.PatientSpecimenGuid, typeof(Guid));
				dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.TestingMethodCode);
				dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.AntibodyTypeId, typeof(int));
				dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.CannedCommentGuid);
				dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.OffsiteIndicator, typeof(bool));
				dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.OffsiteLocation);
				dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.OffsiteCost, typeof(decimal));
				dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.CorrectedResultIndicator, typeof(bool));
				dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.AboRhChangeIndicator, typeof(bool));
				dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.RackGuid, typeof(Guid));
				dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.AutoInstrumentQCIndicator, typeof(bool));
				dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.AutoInstrumentName);
				dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.ReactivityPhaseCode, typeof(char));
			}
			else
			{
				dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.RowVersion, typeof(byte[]));
			}

			dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.SpecimenTestGuid, typeof(Guid));
			dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.TestTechId);
			dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.BloodTestTypeId);
			dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.TestResultId);
			dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.TestDate, typeof(DateTime));
			dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.TestComments);
			dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.DivisionCode);
			//
			return dtSpecimenTest;
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/28/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2828"> 
		///		<ExpectedInput>DataTable containing the results of ABO/Rh testing, output DataTable that will be filled with specimen test data, valid datetime, valid tech id, valid testing method, rack identifier</ExpectedInput>
		///		<ExpectedOutput>Specimen test table containing ABO/Rh testing results</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2829"> 
		///		<ExpectedInput>Invalid parameters</ExpectedInput>
		///		<ExpectedOutput>NullReferenceException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Converts the ABORh testing row to SpecimenTest rows
		/// </summary>
		/// <param name="dtABORhResults"></param>
		/// <param name="dtSpecimenTestsInsert"></param>
		/// <param name="dtSpecimenTestsUpdate"></param>
		/// <param name="testingDateTime"></param>
		/// <param name="testingTechID"></param>
		/// <param name="automatedInstrumentName"></param>
		/// <param name="automatedInstrumentQCd"></param>
		public static void BuildSpecimenTestRowsFromABORh(DataTable dtABORhResults, DataTable dtSpecimenTestsInsert, DataTable dtSpecimenTestsUpdate, DateTime testingDateTime, string testingTechID, string automatedInstrumentName, bool automatedInstrumentQCd)
		{
			DataTable dtBloodTestTypes;
			DataRow drABORhResults = dtABORhResults.Rows[0];
			DataRow drSpecimenTest = null;
			bool update = false;

			dtBloodTestTypes = BOL.BloodTestType.GetBloodTestTypes(drABORhResults[TABLE.BloodTestType.OrderableTestId].ToString());
			foreach(DataColumn col in drABORhResults.Table.Columns)
			{
				if (drABORhResults.IsNull(col) == false)
				{
					if (col.ColumnName == "AntiA" || col.ColumnName == "AntiB" || col.ColumnName == "AntiAB" ||
						col.ColumnName == "A1Cells" || col.ColumnName == "BCells" || col.ColumnName == "AntiD" ||
						col.ColumnName == "ControlD" || col.ColumnName == "RhInterp" || col.ColumnName == "AboInterp")
					{
						string colName = "";
						
						switch(col.ColumnName)
						{
							case "AntiA":
								colName = "Anti A";
								break;
							case "AntiB":
								colName = "Anti B";
								break;
							case "AntiAB":
								colName = "Anti A,B";
								break;
							case "A1Cells":
								colName = "A1 Cells";
								break;
							case "BCells":
								colName = "B Cells";
								break;
							case "AntiD":
								colName = "Anti D";
								break;
							case "ControlD":
								colName = "D Control";
								break;
							case "RhInterp":
								colName = "Rh Interp";
								break;
							case "AboInterp":
								colName = "ABO Interp";
								break;
						}

						string saveColName = col.ColumnName + "Save";
						string guidColName = col.ColumnName + ARTIFICIAL.Guid;
						string rowVersionColName = col.ColumnName + TABLE.BloodUnit.RowVersion;

						if ((bool)drABORhResults[saveColName] == false)
							continue;

						if (drABORhResults.IsNull(guidColName) == true)
						{
							drSpecimenTest = dtSpecimenTestsInsert.NewRow();
							drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid] = Guid.NewGuid();
							dtSpecimenTestsInsert.Rows.Add(drSpecimenTest);
							update = false;
						}
						else
						{
							drSpecimenTest = dtSpecimenTestsUpdate.NewRow();
							drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid] = drABORhResults[guidColName];
							drSpecimenTest[TABLE.SpecimenTest.RowVersion] = drABORhResults[rowVersionColName];
							dtSpecimenTestsUpdate.Rows.Add(drSpecimenTest);
							update = true;
						}

						if ((bool)drABORhResults[saveColName] == true)
						{
							drSpecimenTest[TABLE.SpecimenTest.BloodTestTypeId] = dtBloodTestTypes.Select("BloodTestName LIKE '*" + colName + "*'")[0][TABLE.SpecimenTest.BloodTestTypeId];
							if (drABORhResults[col].ToString().Trim() != "")
								drSpecimenTest[TABLE.SpecimenTest.TestResultId] = drABORhResults[col];
							else
								drSpecimenTest[TABLE.SpecimenTest.TestResultId] = DBNull.Value;

							if (col.ColumnName == "AboInterp")
								drSpecimenTest[TABLE.SpecimenTest.TestComments] = drABORhResults[ARTIFICIAL.AboComment];
							else if (col.ColumnName == "RhInterp")
								drSpecimenTest[TABLE.SpecimenTest.TestComments] = drABORhResults[ARTIFICIAL.RhComment];
						}
					

						if (update == false)
						{
							drSpecimenTest[TABLE.SpecimenTest.OrderedTestGuid] = drABORhResults[TABLE.SpecimenTest.OrderedTestGuid];
							drSpecimenTest[TABLE.SpecimenTest.PatientSpecimenGuid] = drABORhResults[TABLE.SpecimenTest.PatientSpecimenGuid];
							drSpecimenTest[TABLE.SpecimenTest.CorrectedResultIndicator] = drABORhResults[TABLE.SpecimenTest.CorrectedResultIndicator];
							if (automatedInstrumentName != "")
							{
								drSpecimenTest[TABLE.SpecimenTest.AutoInstrumentName] = automatedInstrumentName;
								drSpecimenTest[TABLE.SpecimenTest.AutoInstrumentQCIndicator] = automatedInstrumentQCd;
							}
								drSpecimenTest[TABLE.SpecimenTest.RackGuid] = drABORhResults[TABLE.Rack.RackGuid];
						}

						drSpecimenTest[TABLE.SpecimenTest.TestTechId] = testingTechID;
						drSpecimenTest[TABLE.SpecimenTest.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
						drSpecimenTest[TABLE.SpecimenTest.TestDate] = testingDateTime;
					}
				}
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/28/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2831"> 
		///		<ExpectedInput>DataTable containing the results of DAT testing, output DataTable that will be filled with specimen test data, valid datetime, valid tech id, valid testing method, rack identifier</ExpectedInput>
		///		<ExpectedOutput>Specimen test table containing DAT testing results</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2832"> 
		///		<ExpectedInput>Invalid DAT DataTable, invalid SpecimenTest DataTable, invalid datetime, invalid tech id, invalid testing method, empty guid</ExpectedInput>
		///		<ExpectedOutput>NullReferenceException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Converts the DAT testing row to SpecimenTest rows
		/// </summary>
		/// <param name="dtDATResults"></param>
		/// <param name="dtSpecimenTestsInsert"></param>
		/// <param name="dtSpecimenTestsUpdate"></param>
		/// <param name="testingDateTime"></param>
		/// <param name="testingTechID"></param>
		/// <param name="automatedInstrumentName"></param>
		/// <param name="automatedInstrumentQCd"></param>
		public static void BuildSpecimenTestRowsFromDAT(DataTable dtDATResults, DataTable dtSpecimenTestsInsert, DataTable dtSpecimenTestsUpdate, DateTime testingDateTime, string testingTechID, string automatedInstrumentName, bool automatedInstrumentQCd)
		{
			DataTable dtBloodTestTypes;
			DataRow drDATResults;
			DataRow drSpecimenTest = null;
			bool update = false;

			if (dtDATResults.Rows.Count == 1)
				drDATResults = dtDATResults.Rows[0];
			else
				drDATResults = dtDATResults.Rows[2];

			//OrderableTestId might be for ABS or Repeat ABS test (if the setting for ABS includes DAT).
			//If so, we need to get DAT tests here, not ABS tests.
			if (drDATResults[TABLE.BloodTestType.OrderableTestId].ToString() == ((int)Common.OrderableTest.ABS).ToString())
			{
				dtBloodTestTypes = BOL.BloodTestType.GetBloodTestTypes(Convert.ToInt32(Common.OrderableTest.DAT).ToString());
			}
			else if (drDATResults[TABLE.BloodTestType.OrderableTestId].ToString() == ((int)Common.OrderableTest.RepeatABS).ToString())
			{
				dtBloodTestTypes = BOL.BloodTestType.GetBloodTestTypes(Convert.ToInt32(Common.OrderableTest.RepeatDAT).ToString());
			}
			else
			{
				dtBloodTestTypes = BOL.BloodTestType.GetBloodTestTypes(drDATResults[TABLE.BloodTestType.OrderableTestId].ToString());
			}
			//
			foreach(DataColumn col in drDATResults.Table.Columns)
			{
				if (drDATResults.IsNull(col) == false)
				{
					if (col.ColumnName == ARTIFICIAL.AHG || col.ColumnName == ARTIFICIAL.CC || col.ColumnName == ARTIFICIAL.AHGInterp ||
						col.ColumnName == ARTIFICIAL.IgG || col.ColumnName == ARTIFICIAL.IgGInterp || col.ColumnName == ARTIFICIAL.C3d ||
						col.ColumnName == ARTIFICIAL.C3dInterp)
					{
						string colSave = col.ColumnName + "Save";
						string colGuid = col.ColumnName + ARTIFICIAL.Guid;
						string colRowVersion = col.ColumnName + TABLE.BloodUnit.RowVersion;

						if ((bool)drDATResults[colSave] == false)
							continue;

						if (drDATResults.IsNull(colGuid) == true)
						{
							drSpecimenTest = dtSpecimenTestsInsert.NewRow();
							drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid] = Guid.NewGuid();
							dtSpecimenTestsInsert.Rows.Add(drSpecimenTest);
							update = false;
						}
						else
						{
							drSpecimenTest = dtSpecimenTestsUpdate.NewRow();
							drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid] = drDATResults[colGuid];
							drSpecimenTest[TABLE.SpecimenTest.RowVersion] = drDATResults[colRowVersion];
							dtSpecimenTestsUpdate.Rows.Add(drSpecimenTest);
							update = true;
						}

						if (col.ColumnName == ARTIFICIAL.AHG)
						{
							if ((bool)drDATResults[ARTIFICIAL.AHGSave] == true)
							{
								drSpecimenTest[TABLE.SpecimenTest.BloodTestTypeId] = dtBloodTestTypes.Select("BloodTestName LIKE '" + "*DAT Poly AHG*" + "'")[0][TABLE.SpecimenTest.BloodTestTypeId];
								
								if (drDATResults[col].ToString().Trim() != "")
									drSpecimenTest[TABLE.SpecimenTest.TestResultId] = drDATResults[col];
								else
									drSpecimenTest[TABLE.SpecimenTest.TestResultId] = DBNull.Value;

								drSpecimenTest[TABLE.SpecimenTest.TestComments] = drDATResults[ARTIFICIAL.AHGComment];
							}
						}
						else if (col.ColumnName == ARTIFICIAL.IgG)
						{
							if ((bool)drDATResults[ARTIFICIAL.IgGSave] == true)
							{
								drSpecimenTest[TABLE.SpecimenTest.BloodTestTypeId] = dtBloodTestTypes.Select("BloodTestName LIKE '" + "*AHG*" + "'")[0][TABLE.SpecimenTest.BloodTestTypeId];
								if (drDATResults[col].ToString().Trim() != "")
									drSpecimenTest[TABLE.SpecimenTest.TestResultId] = drDATResults[col];
								else
									drSpecimenTest[TABLE.SpecimenTest.TestResultId] = DBNull.Value;
								drSpecimenTest[TABLE.SpecimenTest.TestComments] = drDATResults[ARTIFICIAL.IgGComment];
							}
						}
						else if (col.ColumnName == ARTIFICIAL.C3d)
						{
							if ((bool)drDATResults[ARTIFICIAL.C3dSave] == true)
							{
								drSpecimenTest[TABLE.SpecimenTest.BloodTestTypeId] = dtBloodTestTypes.Select("BloodTestName LIKE '" + "*AHG*" + "'")[0][TABLE.SpecimenTest.BloodTestTypeId];
								if (drDATResults[col].ToString().Trim() != "")
									drSpecimenTest[TABLE.SpecimenTest.TestResultId] = drDATResults[col];
								else
									drSpecimenTest[TABLE.SpecimenTest.TestResultId] = DBNull.Value;
								drSpecimenTest[TABLE.SpecimenTest.TestComments] = drDATResults[ARTIFICIAL.C3dComment];
							}
						}
						else if (col.ColumnName == ARTIFICIAL.CC)
						{
							if ((bool)drDATResults[ARTIFICIAL.CCSave] == true)
							{
								if(drDATResults[TABLE.BloodTestType.OrderableTestId].ToString() == ((int)Common.OrderableTest.DAT).ToString() ||
									drDATResults[TABLE.BloodTestType.OrderableTestId].ToString() == ((int)Common.OrderableTest.RepeatDAT).ToString() ||
									drDATResults[TABLE.BloodTestType.OrderableTestId].ToString() == ((int)Common.OrderableTest.TAS).ToString() ||
									drDATResults[TABLE.BloodTestType.OrderableTestId].ToString() == ((int)Common.OrderableTest.ABS).ToString() ||
									drDATResults[TABLE.BloodTestType.OrderableTestId].ToString() == ((int)Common.OrderableTest.RepeatABS).ToString())
								{
									drSpecimenTest[TABLE.SpecimenTest.BloodTestTypeId] = dtBloodTestTypes.Select("BloodTestName LIKE '" + "*DAT Poly CC*" + "'")[0][TABLE.SpecimenTest.BloodTestTypeId];
									if (drDATResults[col].ToString().Trim() != "")
										drSpecimenTest[TABLE.SpecimenTest.TestResultId] = drDATResults[col];
									else
										drSpecimenTest[TABLE.SpecimenTest.TestResultId] = DBNull.Value;
									drSpecimenTest[TABLE.SpecimenTest.TestComments] = drDATResults[ARTIFICIAL.AHGComment];
								}
								else if(drDATResults[TABLE.BloodTestType.OrderableTestId].ToString() == ((int)Common.OrderableTest.DATIgG).ToString() ||
									drDATResults[TABLE.BloodTestType.OrderableTestId].ToString() == ((int)Common.OrderableTest.RepeatDATIgG).ToString())
								{
									drSpecimenTest[TABLE.SpecimenTest.BloodTestTypeId] = dtBloodTestTypes.Select("BloodTestName LIKE '" + "*CC*" + "'")[0][TABLE.SpecimenTest.BloodTestTypeId];
									if (drDATResults[col].ToString().Trim() != "")
										drSpecimenTest[TABLE.SpecimenTest.TestResultId] = drDATResults[col];
									else
										drSpecimenTest[TABLE.SpecimenTest.TestResultId] = DBNull.Value;
									drSpecimenTest[TABLE.SpecimenTest.TestComments] = drDATResults[ARTIFICIAL.IgGComment];
								}
								else if(drDATResults[TABLE.BloodTestType.OrderableTestId].ToString() == ((int)Common.OrderableTest.DATComp).ToString() ||
									drDATResults[TABLE.BloodTestType.OrderableTestId].ToString() == ((int)Common.OrderableTest.RepeatDATComp).ToString())
								{
                                    //CR 3554
                                    if (drSpecimenTest == null)
                                        throw new ApplicationException("drSpecimenTest is null");

									drSpecimenTest[TABLE.SpecimenTest.BloodTestTypeId] = dtBloodTestTypes.Select("BloodTestName LIKE '" + "*CC*" + "'")[0][TABLE.SpecimenTest.BloodTestTypeId];
									if (drDATResults[col].ToString().Trim() != "")
										drSpecimenTest[TABLE.SpecimenTest.TestResultId] = drDATResults[col];
									else
										drSpecimenTest[TABLE.SpecimenTest.TestResultId] = DBNull.Value;
									drSpecimenTest[TABLE.SpecimenTest.TestComments] = drDATResults[ARTIFICIAL.C3dComment];
								}
							}
						}
						else if (col.ColumnName == ARTIFICIAL.AHGInterp)
						{
							if ((bool)drDATResults[ARTIFICIAL.AHGInterpSave] == true)
							{
								drSpecimenTest[TABLE.SpecimenTest.BloodTestTypeId] = dtBloodTestTypes.Select("BloodTestName LIKE '" + "*DAT Poly Interp*" + "'")[0][TABLE.SpecimenTest.BloodTestTypeId];
								if (drDATResults[col].ToString().Trim() != "")
									drSpecimenTest[TABLE.SpecimenTest.TestResultId] = drDATResults[col];
								else
									drSpecimenTest[TABLE.SpecimenTest.TestResultId] = DBNull.Value;
								drSpecimenTest[TABLE.SpecimenTest.TestComments] = drDATResults[ARTIFICIAL.AHGComment];
							}
						}
						else if (col.ColumnName == ARTIFICIAL.IgGInterp)
						{
							if ((bool)drDATResults[ARTIFICIAL.IgGInterpSave] == true)
							{
								drSpecimenTest[TABLE.SpecimenTest.BloodTestTypeId] = dtBloodTestTypes.Select("BloodTestName LIKE '" + "*Interp*" + "'")[0][TABLE.SpecimenTest.BloodTestTypeId];
								if (drDATResults[col].ToString().Trim() != "")
									drSpecimenTest[TABLE.SpecimenTest.TestResultId] = drDATResults[col];
								else
									drSpecimenTest[TABLE.SpecimenTest.TestResultId] = DBNull.Value;
								drSpecimenTest[TABLE.SpecimenTest.TestComments] = drDATResults[ARTIFICIAL.IgGComment];
							}
						}
						else if (col.ColumnName == ARTIFICIAL.C3dInterp)
						{
							if ((bool)drDATResults[ARTIFICIAL.C3dInterpSave] == true)
							{
								drSpecimenTest[TABLE.SpecimenTest.BloodTestTypeId] = dtBloodTestTypes.Select("BloodTestName LIKE '" + "*Interp*" + "'")[0][TABLE.SpecimenTest.BloodTestTypeId];
								if (drDATResults[col].ToString().Trim() != "")
									drSpecimenTest[TABLE.SpecimenTest.TestResultId] = drDATResults[col];
								else
									drSpecimenTest[TABLE.SpecimenTest.TestResultId] = DBNull.Value;
								drSpecimenTest[TABLE.SpecimenTest.TestComments] = drDATResults[ARTIFICIAL.C3dComment];
							}
						}

						if (update == false)
						{
							drSpecimenTest[TABLE.SpecimenTest.OrderedTestGuid] = drDATResults[TABLE.SpecimenTest.OrderedTestGuid];
							drSpecimenTest[TABLE.SpecimenTest.PatientSpecimenGuid] = drDATResults[TABLE.SpecimenTest.PatientSpecimenGuid];
							drSpecimenTest[TABLE.SpecimenTest.CorrectedResultIndicator] = drDATResults[TABLE.SpecimenTest.CorrectedResultIndicator];
							drSpecimenTest[TABLE.SpecimenTest.RackGuid] = drDATResults[TABLE.SpecimenTest.RackGuid];

							if (automatedInstrumentName != "")
							{
								drSpecimenTest[TABLE.SpecimenTest.AutoInstrumentName] = automatedInstrumentName;
								drSpecimenTest[TABLE.SpecimenTest.AutoInstrumentQCIndicator] = automatedInstrumentQCd;
							}
						}

						drSpecimenTest[TABLE.SpecimenTest.TestTechId] = testingTechID;
						drSpecimenTest[TABLE.SpecimenTest.TestDate] = testingDateTime;
						drSpecimenTest[TABLE.SpecimenTest.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
					}
				}
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/28/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2833"> 
		///		<ExpectedInput>DataTable containing results of DAT testing, output DataTable that will be filled with RackLot data, output DataTable that will be filled with RackTest data
		///						DataTable that will be filled with AntiseraOrderedTest data, rack identifier, division code</ExpectedInput>
		///		<ExpectedOutput>DataTable containing RackLot data, DataTable containing RackTest data, DataTable containing AntiseraOrderedTest data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2834"> 
		///		<ExpectedInput>Invalid DAT DataTable, invalid RackLots DataTable, invalid RackTests DataTable, invalid AntiseraOrderedTest DataTable, empty guid, invalid division code</ExpectedInput>
		///		<ExpectedOutput>NullReferenceException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Build QC DataTables from DAT test results
		/// </summary>
		/// <param name="dtDATResults"></param>
		/// <param name="dtRackLots"></param>
		/// <param name="dtRackTestsInsert"></param>
		/// <param name="dtRackTestsUpdate"></param>
		/// <param name="dtAntiseraOrderedTests"></param>
		/// <param name="testingDateTime"></param>
		/// <param name="testingUser"></param>
		public static void BuildQCDataFromDAT(DataTable dtDATResults, DataTable dtRackLots, 
											  DataTable dtRackTestsInsert, DataTable dtRackTestsUpdate, DataTable dtAntiseraOrderedTests, 
											  DateTime testingDateTime, string testingUser)
		{
			DataTable dtQCResults = new DataTable();
			DataRow drRackLot;
			DataRow drAntiseraOrderedTest;
			string Interp = "";
			int RackLotCount = 0;

			if (dtDATResults.Rows.Count == 1)
			{
				if (dtDATResults.Rows[0][TABLE.Reagent.LotNumber].ToString().Trim() == "")
				{
					RackLotCount = 0;
				}
				else
				{
					dtQCResults = OrderedTest.GetQCResultsForOrderedTest((Guid)dtDATResults.Rows[0][TABLE.SpecimenTest.OrderedTestGuid]);
					RackLotCount = 1;
				}
			}
			else if (dtDATResults.Rows.Count == 3)
			{
				dtQCResults = OrderedTest.GetQCResultsForOrderedTest((Guid)dtDATResults.Rows[2][TABLE.SpecimenTest.OrderedTestGuid]);
				RackLotCount = 2;
			}

			for (int i=0; i<RackLotCount ; i++)
			{
				//checking if the RackLot for this reagent already exists
				if (dtQCResults.Select("ReagentGuid = '" + dtDATResults.Rows[i][TABLE.RackLot.ReagentGuid].ToString() + "' AND RecordStatusCode = 'A'").Length == 0)
				{
					//rack lot for POS and NEG controls
					drRackLot = dtRackLots.NewRow();

					drRackLot[TABLE.RackLot.RackLotGuid] = Guid.NewGuid();
					drRackLot[TABLE.RackLot.ReagentGuid] = dtDATResults.Rows[i][TABLE.RackLot.ReagentGuid];
					drRackLot[TABLE.RackLot.LotUseDate] = testingDateTime;
					drRackLot[TABLE.RackLot.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
					drRackLot[TABLE.RackLot.LastUpdateUser] = Common.LogonUser.LogonUserName;
					if (i == 0)
						drRackLot[TABLE.RackLot.ControlCellId] = true;	//POS
					else
						drRackLot[TABLE.RackLot.ControlCellId] = false;	//NEG

					dtRackLots.Rows.Add(drRackLot);

					drAntiseraOrderedTest = dtAntiseraOrderedTests.NewRow();
					drAntiseraOrderedTest[TABLE.AntiseraOrderedTest.AntiseraOrderedTestGuid] = Guid.NewGuid();
					drAntiseraOrderedTest[TABLE.AntiseraOrderedTest.RackLotGuid] = drRackLot[TABLE.RackLot.RackLotGuid];

					if (dtDATResults.Rows.Count == 1)
					{
						drAntiseraOrderedTest[TABLE.AntiseraOrderedTest.OrderedTestGuid] = dtDATResults.Rows[0][TABLE.SpecimenTest.OrderedTestGuid];
					}
					else if (dtDATResults.Rows.Count == 3)
					{
						drAntiseraOrderedTest[TABLE.AntiseraOrderedTest.OrderedTestGuid] = dtDATResults.Rows[2][TABLE.SpecimenTest.OrderedTestGuid];
					}

					drAntiseraOrderedTest[TABLE.RackLot.LastUpdateUser] = Common.LogonUser.LogonUserName;
					drAntiseraOrderedTest[TABLE.AntiseraOrderedTest.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active);
					dtAntiseraOrderedTests.Rows.Add(drAntiseraOrderedTest);
				}

				if (RackLotCount == 2)
				{
					//rack lot for speciment test
					drRackLot = dtRackLots.NewRow();

					if (dtQCResults.Select("ReagentGuid = '" + dtDATResults.Rows[2][TABLE.RackLot.ReagentGuid].ToString() + "' AND RecordStatusCode = 'A'").Length == 0)
					{
						drRackLot[TABLE.RackLot.RackLotGuid] = Guid.NewGuid();

						drAntiseraOrderedTest = dtAntiseraOrderedTests.NewRow();
						drAntiseraOrderedTest[TABLE.AntiseraOrderedTest.AntiseraOrderedTestGuid] = Guid.NewGuid();
						drAntiseraOrderedTest[TABLE.AntiseraOrderedTest.RackLotGuid] = drRackLot[TABLE.RackLot.RackLotGuid];
						drAntiseraOrderedTest[TABLE.AntiseraOrderedTest.OrderedTestGuid] = dtDATResults.Rows[2][TABLE.SpecimenTest.OrderedTestGuid];
						drAntiseraOrderedTest[TABLE.RackLot.LastUpdateUser] = Common.LogonUser.LogonUserName;
						drAntiseraOrderedTest[TABLE.AntiseraOrderedTest.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active);
						dtAntiseraOrderedTests.Rows.Add(drAntiseraOrderedTest);
					}
					else
					{
						if (i == 0)
						{
							drRackLot[TABLE.RackLot.RackLotGuid] = (Guid)dtQCResults.Select("ReagentGuid = '" + dtDATResults.Rows[2][TABLE.RackLot.ReagentGuid].ToString() + "' AND ControlCellId = 1")[0][TABLE.RackLot.RackLotGuid];
							drRackLot[TABLE.RackLot.RowVersion] = (byte[])dtQCResults.Select("ReagentGuid = '" + dtDATResults.Rows[2][TABLE.RackLot.ReagentGuid].ToString() + "' AND ControlCellId = 1")[0][TABLE.RackLot.RowVersion];
						}
						else if (i == 1)
						{
							drRackLot[TABLE.RackLot.RackLotGuid] = (Guid)dtQCResults.Select("ReagentGuid = '" + dtDATResults.Rows[2][TABLE.RackLot.ReagentGuid].ToString() + "' AND ControlCellId = 0")[0][TABLE.RackLot.RackLotGuid];
							drRackLot[TABLE.RackLot.RowVersion] = (byte[])dtQCResults.Select("ReagentGuid = '" + dtDATResults.Rows[2][TABLE.RackLot.ReagentGuid].ToString() + "' AND ControlCellId = 0")[0][TABLE.RackLot.RowVersion];
						}
					}

					if (dtDATResults.Rows[0][TABLE.BloodTestType.OrderableTestId].ToString() == ((int)Common.OrderableTest.DAT).ToString() ||
						dtDATResults.Rows[0][TABLE.BloodTestType.OrderableTestId].ToString() == ((int)Common.OrderableTest.RepeatDAT).ToString())
					{
						drRackLot[TABLE.RackLot.Comments] = dtDATResults.Rows[i][ARTIFICIAL.AHGComment];
					}
					else if (dtDATResults.Rows[0][TABLE.BloodTestType.OrderableTestId].ToString() == ((int)Common.OrderableTest.DATIgG).ToString() ||
							 dtDATResults.Rows[0][TABLE.BloodTestType.OrderableTestId].ToString() == ((int)Common.OrderableTest.RepeatDATIgG).ToString())
					{
						drRackLot[TABLE.RackLot.Comments] = dtDATResults.Rows[i][ARTIFICIAL.IgGComment];
					}
					else if (dtDATResults.Rows[0][TABLE.BloodTestType.OrderableTestId].ToString() == ((int)Common.OrderableTest.DATComp).ToString() ||
							 dtDATResults.Rows[0][TABLE.BloodTestType.OrderableTestId].ToString() == ((int)Common.OrderableTest.RepeatDATComp).ToString())
					{
						drRackLot[TABLE.RackLot.Comments] = dtDATResults.Rows[i][ARTIFICIAL.C3dComment];
					}

					drRackLot[TABLE.SpecimenTest.RackGuid] = dtDATResults.Rows[0][TABLE.Rack.RackGuid];
					drRackLot[TABLE.RackLot.ReagentGuid] = dtDATResults.Rows[2][TABLE.RackLot.ReagentGuid];
					drRackLot[TABLE.RackLot.TestWithId] = dtDATResults.Rows[i][TABLE.ReagentType.ReagentTypeId];

					if (dtDATResults.Rows[0][TABLE.BloodTestType.OrderableTestId].ToString() == ((int)Common.OrderableTest.DAT).ToString() ||
						dtDATResults.Rows[0][TABLE.BloodTestType.OrderableTestId].ToString() == ((int)Common.OrderableTest.RepeatDAT).ToString() ||
						dtDATResults.Rows[0][TABLE.BloodTestType.OrderableTestId].ToString() == ((int)Common.OrderableTest.TAS).ToString())
					{
						drRackLot[TABLE.ReagentType.ReactivityPhaseCode] = ((int)Common.ReactivityPhase.AHGandCC).ToString();
					}
					else if (dtDATResults.Rows[0][TABLE.BloodTestType.OrderableTestId].ToString() == ((int)Common.OrderableTest.DATIgG).ToString() ||
							 dtDATResults.Rows[0][TABLE.BloodTestType.OrderableTestId].ToString() == ((int)Common.OrderableTest.RepeatDATIgG).ToString() ||
							 dtDATResults.Rows[0][TABLE.BloodTestType.OrderableTestId].ToString() == ((int)Common.OrderableTest.DATComp).ToString() ||
							 dtDATResults.Rows[0][TABLE.BloodTestType.OrderableTestId].ToString() == ((int)Common.OrderableTest.RepeatDATComp).ToString())
					{
						drRackLot[TABLE.ReagentType.ReactivityPhaseCode] = ((int)Common.ReactivityPhase.AHGandCC).ToString();
					}

					drRackLot[TABLE.RackLot.LotUseDate] = testingDateTime;
					drRackLot[TABLE.RackLot.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
					drRackLot[TABLE.RackLot.LastUpdateUser] = Common.LogonUser.LogonUserName;
					if (i == 0)
						drRackLot[TABLE.RackLot.ControlCellId] = true;	//POS
					else
						drRackLot[TABLE.RackLot.ControlCellId] = false;	//NEG

					if (dtDATResults.Rows[0][TABLE.BloodTestType.OrderableTestId].ToString() == ((int)Common.OrderableTest.DAT).ToString() ||
						dtDATResults.Rows[0][TABLE.BloodTestType.OrderableTestId].ToString() == ((int)Common.OrderableTest.RepeatDAT).ToString() ||
						dtDATResults.Rows[0][TABLE.BloodTestType.OrderableTestId].ToString() == ((int)Common.OrderableTest.TAS).ToString())
					{
						Interp = dtDATResults.Rows[i][ARTIFICIAL.AHGInterp].ToString();
					}
					else if (dtDATResults.Rows[0][TABLE.BloodTestType.OrderableTestId].ToString() == ((int)Common.OrderableTest.DATIgG).ToString() ||
							 dtDATResults.Rows[0][TABLE.BloodTestType.OrderableTestId].ToString() == ((int)Common.OrderableTest.RepeatDATIgG).ToString())
					{
						Interp = dtDATResults.Rows[i][ARTIFICIAL.IgGInterp].ToString();
					}
					else if (dtDATResults.Rows[0][TABLE.BloodTestType.OrderableTestId].ToString() == ((int)Common.OrderableTest.DATComp).ToString() ||
							 dtDATResults.Rows[0][TABLE.BloodTestType.OrderableTestId].ToString() == ((int)Common.OrderableTest.RepeatDATComp).ToString())
					{
						Interp = dtDATResults.Rows[i][ARTIFICIAL.C3dInterp].ToString();
					}

					if ((Interp == "P" && i == 0) ||
						(Interp == "N" && i == 1))
					{
						drRackLot[TABLE.RackLot.SatisfactoryResultIndicator] = true;
					}
					else if ((Interp == "N" && i == 0) ||
						(Interp == "P" && i == 1))
					{
						drRackLot[TABLE.RackLot.SatisfactoryResultIndicator] = false;
					}

					dtRackLots.Rows.Add(drRackLot);

					DataRow drRackTest = null;
					bool update = false;
					//test results of AHG QC go to RackTest
					foreach(DataColumn col in dtDATResults.Columns)
					{
						if (col.ColumnName == ARTIFICIAL.AHG || col.ColumnName == ARTIFICIAL.IgG || col.ColumnName == ARTIFICIAL.C3d ||
							col.ColumnName == ARTIFICIAL.CC)
						{
							if (dtDATResults.Rows[i].IsNull(col) == false)
							{
								string colSave = col.ColumnName + "Save";
								string colGuid = col.ColumnName + ARTIFICIAL.Guid;
								string colRowVersion = col.ColumnName + TABLE.BloodUnit.RowVersion;

								if ((bool)dtDATResults.Rows[i][colSave] == false)
									continue;

								if (dtDATResults.Rows[i].IsNull(colGuid) == true)
								{
									drRackTest = dtRackTestsInsert.NewRow();
									drRackTest[TABLE.RackTest.RackTestGuid] = Guid.NewGuid();
									dtRackTestsInsert.Rows.Add(drRackTest);
									update = false;
								}
								else
								{
									drRackTest = dtRackTestsUpdate.NewRow();
									drRackTest[TABLE.RackTest.RackTestGuid] = dtDATResults.Rows[i][colGuid];
									drRackTest[TABLE.RackTest.RowVersion] = dtDATResults.Rows[i][colRowVersion];
									dtRackTestsUpdate.Rows.Add(drRackTest);
									update = true;
								}

								if (update == false)
								{
									drRackTest[TABLE.RackTest.RackLotGuid] = drRackLot[TABLE.RackLot.RackLotGuid];
								}

								drRackTest[TABLE.RackTest.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
								drRackTest[TABLE.RackTest.TestDate] = testingDateTime;
								drRackTest[TABLE.RackTest.TestTechId] = testingUser;
								drRackTest[TABLE.RackTest.RecordStatusCode] = "A";
								drRackTest[TABLE.RackTest.LastUpdateUser] = Common.LogonUser.LogonUserName;

								if (dtDATResults.Rows[i][col].ToString().Trim() != "")
									drRackTest[TABLE.RackTest.RackTestResult] = dtDATResults.Rows[i][col];
								else
									drRackTest[TABLE.RackTest.RackTestResult] = DBNull.Value;

								if (col.ColumnName == ARTIFICIAL.AHG)
								{
									if ((bool)dtDATResults.Rows[i][ARTIFICIAL.AHGSave] == true)
									{
										if (update == false)
											drRackTest[TABLE.RackTest.RackTestResultTypeCode] = ARTIFICIAL.AHG;
									}
								}
								else if (col.ColumnName == ARTIFICIAL.IgG)
								{
									if ((bool)dtDATResults.Rows[i][ARTIFICIAL.IgGSave] == true)
									{
										if (update == false)
											drRackTest[TABLE.RackTest.RackTestResultTypeCode] = ARTIFICIAL.AHG;
									}
								}
								else if (col.ColumnName == ARTIFICIAL.C3d)
								{
									if ((bool)dtDATResults.Rows[i][ARTIFICIAL.C3dSave] == true)
									{
										if (update == false)
											drRackTest[TABLE.RackTest.RackTestResultTypeCode] = ARTIFICIAL.AHG;
									}
								}
								else if (col.ColumnName == ARTIFICIAL.CC)
								{
									if ((bool)dtDATResults.Rows[i][ARTIFICIAL.CCSave] == true)
									{
										if (update == false)
											drRackTest[TABLE.RackTest.RackTestResultTypeCode] = ARTIFICIAL.CC;
									}
								}
							}
						}
					}
				}
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/3/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2987"> 
		///		<ExpectedInput>DataTable containing the results of antigen typing, output DataTable that will be filled with specimen test data, valid datetime, valid tech id, valid testing method, rack identifier</ExpectedInput>
		///		<ExpectedOutput>Specimen test table containing antigen typing results</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2988"> 
		///		<ExpectedInput>Invalid AGT DataTable, invalid SpecimenTest DataTable, invalid datetime, invalid tech id, invalid testing method, empty guid</ExpectedInput>
		///		<ExpectedOutput>NullReferenceException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Builds specimen test rows for AGT
		/// </summary>
		/// <param name="dtAGTResults"></param>
		/// <param name="dtSpecimenTestsInsert"></param>
		/// <param name="dtSpecimenTestsUpdate"></param>
		/// <param name="testingDateTime"></param>
		/// <param name="testingTechID"></param>
		/// <param name="testMethod"></param>
		/// <param name="automatedInstrumentName"></param>
		/// <param name="automatedInstrumentQCd"></param>
		public static void BuildSpecimenTestRowsFromAGT(DataTable dtAGTResults, DataTable dtSpecimenTestsInsert, DataTable dtSpecimenTestsUpdate, DateTime testingDateTime, string testingTechID, Common.TestingMethod testMethod, string automatedInstrumentName, bool automatedInstrumentQCd)
		{
			DataTable dtBloodTestTypes;
			bool WeakDTyping = false;
			DataRow drSpecimenTest = null;
			bool update = false;

//			foreach(DataTable dtAGTResults in dsPatientTestResults.Tables)
//			{
//				//find only tables that contain antigen typing results
//				if (dtAGTResults.TableName.Substring(0,2) == "AG")
//				{
					foreach (DataRow drAGTResults in dtAGTResults.Rows)
					{
						if (System.Convert.ToInt32(drAGTResults[TABLE.BloodTestType.OrderableTestId]) == (int)Common.OrderableTest.AGwD ||
							System.Convert.ToInt32(drAGTResults[TABLE.BloodTestType.OrderableTestId]) == (int)Common.OrderableTest.RepeatAGwD)
						{
							WeakDTyping = true;
						}
						else
						{
							WeakDTyping = false;
						}

						//saving results only for weak d typing rows or patient typing rows (the rest is being saved as qc results not patient testing results)
						if (WeakDTyping || drAGTResults[ARTIFICIAL.TestType].ToString() == "Patient")
						{
							dtBloodTestTypes = BOL.BloodTestType.GetBloodTestTypes(drAGTResults[TABLE.BloodTestType.OrderableTestId].ToString());
							foreach(DataColumn col in drAGTResults.Table.Columns)
							{
								if (drAGTResults.IsNull(col) == false)
								{
									if (col.ColumnName == ARTIFICIAL.IS || col.ColumnName == ARTIFICIAL.RT || col.ColumnName == ARTIFICIAL.C37 ||
										col.ColumnName == ARTIFICIAL.AHG || col.ColumnName == ARTIFICIAL.CC || col.ColumnName == ARTIFICIAL.Interp)
									{
										string colSave = col.ColumnName + "Save";
										string colGuid = col.ColumnName + ARTIFICIAL.Guid;
										string colRowVersion = col.ColumnName + TABLE.BloodUnit.RowVersion;

										if ((bool)drAGTResults[colSave] == false)
											continue;

										if (drAGTResults.IsNull(colGuid) == true)
										{
											drSpecimenTest = dtSpecimenTestsInsert.NewRow();
											drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid] = Guid.NewGuid();
											dtSpecimenTestsInsert.Rows.Add(drSpecimenTest);
											update = false;
										}
										else
										{
											drSpecimenTest = dtSpecimenTestsUpdate.NewRow();
											drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid] = drAGTResults[colGuid];
											drSpecimenTest[TABLE.SpecimenTest.RowVersion] = drAGTResults[colRowVersion];
											dtSpecimenTestsUpdate.Rows.Add(drSpecimenTest);
											update = true;
										}

										if (col.ColumnName == ARTIFICIAL.IS)
										{
											if ((bool)drAGTResults[ARTIFICIAL.ISSave] == true)
											{
												if (WeakDTyping == true)
												{
													if ((int)drAGTResults[TABLE.ReagentType.ReagentTypeId] == (int)Common.WeakDTestReagents.AntiD)
													{
														drSpecimenTest[TABLE.SpecimenTest.BloodTestTypeId] = dtBloodTestTypes.Select("BloodTestName LIKE '" + "*Anti wD IS*" + "'")[0][TABLE.SpecimenTest.BloodTestTypeId];
													}
													else if ((int)drAGTResults[TABLE.ReagentType.ReagentTypeId] == (int)Common.WeakDTestReagents.AntiDControl)
													{
														drSpecimenTest[TABLE.SpecimenTest.BloodTestTypeId] = dtBloodTestTypes.Select("BloodTestName LIKE '" + "*D Control IS*" + "'")[0][TABLE.SpecimenTest.BloodTestTypeId];
													}
												}
												else
												{
													drSpecimenTest[TABLE.SpecimenTest.BloodTestTypeId] = dtBloodTestTypes.Select("BloodTestName LIKE '" + "*IS*" + "'")[0][TABLE.SpecimenTest.BloodTestTypeId];
												}
												if (drAGTResults[col].ToString().Trim() != "")
													drSpecimenTest[TABLE.SpecimenTest.TestResultId] = drAGTResults[col];
												else
													drSpecimenTest[TABLE.SpecimenTest.TestResultId] = DBNull.Value;

												if (drAGTResults.IsNull(ARTIFICIAL.Comment))
												{
													drSpecimenTest[TABLE.SpecimenTest.TestComments] = "";
												}
												else
												{
													drSpecimenTest[TABLE.SpecimenTest.TestComments] = drAGTResults[ARTIFICIAL.Comment];
												}
											}
										}
										else if (col.ColumnName == ARTIFICIAL.RT)
										{
											if ((bool)drAGTResults[ARTIFICIAL.RTSave] == true)
											{
												if (WeakDTyping == true)
												{
													if ((int)drAGTResults[TABLE.ReagentType.ReagentTypeId] == (int)Common.WeakDTestReagents.AntiD)
													{
														drSpecimenTest[TABLE.SpecimenTest.BloodTestTypeId] = dtBloodTestTypes.Select("BloodTestName LIKE '" + "*Anti wD RT*" + "'")[0][TABLE.SpecimenTest.BloodTestTypeId];
													}
													else if ((int)drAGTResults[TABLE.ReagentType.ReagentTypeId] == (int)Common.WeakDTestReagents.AntiDControl)
													{
														drSpecimenTest[TABLE.SpecimenTest.BloodTestTypeId] = dtBloodTestTypes.Select("BloodTestName LIKE '" + "*D Control RT*" + "'")[0][TABLE.SpecimenTest.BloodTestTypeId];
													}
												}
												else
												{
													drSpecimenTest[TABLE.SpecimenTest.BloodTestTypeId] = dtBloodTestTypes.Select("BloodTestName LIKE '" + "*RT*" + "'")[0][TABLE.SpecimenTest.BloodTestTypeId];
												}
												if (drAGTResults[col].ToString().Trim() != "")
													drSpecimenTest[TABLE.SpecimenTest.TestResultId] = drAGTResults[col];
												else
													drSpecimenTest[TABLE.SpecimenTest.TestResultId] = DBNull.Value;

												if (drAGTResults.IsNull(ARTIFICIAL.Comment))
												{
													drSpecimenTest[TABLE.SpecimenTest.TestComments] = "";
												}
												else
												{
													drSpecimenTest[TABLE.SpecimenTest.TestComments] = drAGTResults[ARTIFICIAL.Comment];
												}
											}
										}
										else if (col.ColumnName == ARTIFICIAL.C37)
										{
											if ((bool)drAGTResults[ARTIFICIAL.C37Save] == true)
											{
												if (WeakDTyping == true)
												{
													if ((int)drAGTResults[TABLE.ReagentType.ReagentTypeId] == (int)Common.WeakDTestReagents.AntiD)
													{
														drSpecimenTest[TABLE.SpecimenTest.BloodTestTypeId] = dtBloodTestTypes.Select("BloodTestName LIKE '" + "*Anti wD 37*" + "'")[0][TABLE.SpecimenTest.BloodTestTypeId];
													}
													else if ((int)drAGTResults[TABLE.ReagentType.ReagentTypeId] == (int)Common.WeakDTestReagents.AntiDControl)
													{
														drSpecimenTest[TABLE.SpecimenTest.BloodTestTypeId] = dtBloodTestTypes.Select("BloodTestName LIKE '" + "*D Control 37*" + "'")[0][TABLE.SpecimenTest.BloodTestTypeId];
													}
												}
												else
												{
													drSpecimenTest[TABLE.SpecimenTest.BloodTestTypeId] = dtBloodTestTypes.Select("BloodTestName LIKE '" + "*37*" + "'")[0][TABLE.SpecimenTest.BloodTestTypeId];
												}
												if (drAGTResults[col].ToString().Trim() != "")
													drSpecimenTest[TABLE.SpecimenTest.TestResultId] = drAGTResults[col];
												else
													drSpecimenTest[TABLE.SpecimenTest.TestResultId] = DBNull.Value;

												if (drAGTResults.IsNull(ARTIFICIAL.Comment))
												{
													drSpecimenTest[TABLE.SpecimenTest.TestComments] = "";
												}
												else
												{
													drSpecimenTest[TABLE.SpecimenTest.TestComments] = drAGTResults[ARTIFICIAL.Comment];
												}
											}
										}
										else if (col.ColumnName == ARTIFICIAL.AHG)
										{
											if ((bool)drAGTResults[ARTIFICIAL.AHGSave] == true)
											{
												if (WeakDTyping == true)
												{
													if ((int)drAGTResults[TABLE.ReagentType.ReagentTypeId] == (int)Common.WeakDTestReagents.AntiD)
													{
														drSpecimenTest[TABLE.SpecimenTest.BloodTestTypeId] = dtBloodTestTypes.Select("BloodTestName LIKE '" + "*Anti wD AHG*" + "'")[0][TABLE.SpecimenTest.BloodTestTypeId];
													}
													else if ((int)drAGTResults[TABLE.ReagentType.ReagentTypeId] == (int)Common.WeakDTestReagents.AntiDControl)
													{
														drSpecimenTest[TABLE.SpecimenTest.BloodTestTypeId] = dtBloodTestTypes.Select("BloodTestName LIKE '" + "*D Control AHG*" + "'")[0][TABLE.SpecimenTest.BloodTestTypeId];
													}
												}
												else
												{
													drSpecimenTest[TABLE.SpecimenTest.BloodTestTypeId] = dtBloodTestTypes.Select("BloodTestName LIKE '" + "*AHG*" + "'")[0][TABLE.SpecimenTest.BloodTestTypeId];
												}

												if (drAGTResults[col].ToString().Trim() != "")
													drSpecimenTest[TABLE.SpecimenTest.TestResultId] = drAGTResults[col];
												else
													drSpecimenTest[TABLE.SpecimenTest.TestResultId] = DBNull.Value;
												
												if (drAGTResults.IsNull(ARTIFICIAL.Comment))
												{
													drSpecimenTest[TABLE.SpecimenTest.TestComments] = "";
												}
												else
												{
													drSpecimenTest[TABLE.SpecimenTest.TestComments] = drAGTResults[ARTIFICIAL.Comment];
												}
											}
										}
										else if (col.ColumnName == ARTIFICIAL.CC)
										{
											if ((bool)drAGTResults[ARTIFICIAL.CCSave] == true)
											{
												if (WeakDTyping == true)
												{
													if ((int)drAGTResults[TABLE.ReagentType.ReagentTypeId] == (int)Common.WeakDTestReagents.AntiD)
													{
														drSpecimenTest[TABLE.SpecimenTest.BloodTestTypeId] = dtBloodTestTypes.Select("BloodTestName LIKE '" + "*Anti wD CC*" + "'")[0][TABLE.SpecimenTest.BloodTestTypeId];
													}
													else if ((int)drAGTResults[TABLE.ReagentType.ReagentTypeId] == (int)Common.WeakDTestReagents.AntiDControl)
													{
														drSpecimenTest[TABLE.SpecimenTest.BloodTestTypeId] = dtBloodTestTypes.Select("BloodTestName LIKE '" + "*D Control CC*" + "'")[0][TABLE.SpecimenTest.BloodTestTypeId];
													}
												}
												else
												{
													drSpecimenTest[TABLE.SpecimenTest.BloodTestTypeId] = dtBloodTestTypes.Select("BloodTestName LIKE '" + "*CC*" + "'")[0][TABLE.SpecimenTest.BloodTestTypeId];
												}

												if (drAGTResults[col].ToString().Trim() != "")
													drSpecimenTest[TABLE.SpecimenTest.TestResultId] = drAGTResults[col];
												else
													drSpecimenTest[TABLE.SpecimenTest.TestResultId] = DBNull.Value;
												
												if (drAGTResults.IsNull(ARTIFICIAL.Comment))
												{
													drSpecimenTest[TABLE.SpecimenTest.TestComments] = "";
												}
												else
												{
													drSpecimenTest[TABLE.SpecimenTest.TestComments] = drAGTResults[ARTIFICIAL.Comment];
												}
											}
										}
										else if (col.ColumnName == ARTIFICIAL.Interp)
										{
											if ((bool)drAGTResults[ARTIFICIAL.InterpSave] == true)
											{
												drSpecimenTest[TABLE.SpecimenTest.BloodTestTypeId] = dtBloodTestTypes.Select("BloodTestName LIKE '" + "*Interp*" + "'")[0][TABLE.SpecimenTest.BloodTestTypeId];

												if (drAGTResults[col].ToString().Trim() != "")
													drSpecimenTest[TABLE.SpecimenTest.TestResultId] = drAGTResults[col];
												else
													drSpecimenTest[TABLE.SpecimenTest.TestResultId] = DBNull.Value;
												
												if (drAGTResults.IsNull(ARTIFICIAL.Comment))
												{
													drSpecimenTest[TABLE.SpecimenTest.TestComments] = "";
												}
												else
												{
													drSpecimenTest[TABLE.SpecimenTest.TestComments] = drAGTResults[ARTIFICIAL.Comment];
												}
											}
										}

										if (update == false)
										{
											drSpecimenTest[TABLE.SpecimenTest.OrderedTestGuid] = drAGTResults[TABLE.SpecimenTest.OrderedTestGuid];
											drSpecimenTest[TABLE.SpecimenTest.PatientSpecimenGuid] = drAGTResults[TABLE.SpecimenTest.PatientSpecimenGuid];
											drSpecimenTest[TABLE.SpecimenTest.CorrectedResultIndicator] = drAGTResults[TABLE.SpecimenTest.CorrectedResultIndicator];
											drSpecimenTest[TABLE.SpecimenTest.RackGuid] = drAGTResults[TABLE.SpecimenTest.RackGuid];

											if (Common.Utility.GetTestingMethodCodeFromEnum(testMethod) != char.MinValue)
												drSpecimenTest[TABLE.SpecimenTest.TestingMethodCode] = Common.Utility.GetTestingMethodCodeFromEnum(testMethod);

											if (automatedInstrumentName != "")
											{
												drSpecimenTest[TABLE.SpecimenTest.AutoInstrumentName] = automatedInstrumentName;
												drSpecimenTest[TABLE.SpecimenTest.AutoInstrumentQCIndicator] = automatedInstrumentQCd;
											}
										}

										drSpecimenTest[TABLE.SpecimenTest.TestTechId] = testingTechID;
										drSpecimenTest[TABLE.SpecimenTest.TestDate] = testingDateTime;
										drSpecimenTest[TABLE.SpecimenTest.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
									}
								}
							}
						}
					}
//				}
//			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/3/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2985"> 
		///		<ExpectedInput>DataTable containing results of antigen typing, output DataTable that will be filled with RackLot data, output DataTable that will be filled with RackTest data
		///						DataTable that will be filled with AntiseraOrderedTest data, rack identifier, division code</ExpectedInput>
		///		<ExpectedOutput>DataTable containing RackLot data, DataTable containing RackTest data, DataTable containing AntiseraOrderedTest data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2986"> 
		///		<ExpectedInput>Invalid AGT DataTable, invalid RackLots DataTable, invalid RackTests DataTable, invalid AntiseraOrderedTest DataTable, empty guid, invalid division code</ExpectedInput>
		///		<ExpectedOutput>NullReferenceException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Builds QCData from AGT test results that are being inserted into the database
		/// </summary>
		/// <param name="dtAGTResults"></param>
		/// <param name="dtRackLots"></param>
		/// <param name="dtRackTestsInsert"></param>
		/// <param name="dtRackTestsUpdate"></param>
		/// <param name="dtAntiseraOrderedTests"></param>
		/// <param name="testingDateTime"></param>
		/// <param name="testingUser"></param>
		public static void BuildQCDataFromAGT(DataTable dtAGTResults, 
											  DataTable dtRackLots, DataTable dtRackTestsInsert, DataTable dtRackTestsUpdate,
											  DataTable dtAntiseraOrderedTests, DateTime testingDateTime, string testingUser)
		{
			DataTable dtQCResults = new DataTable();
			DataRow drRackLot;
			DataRow drAntiseraOrderedTest;
			string Interp = "";
			int RackLotCount = 0;

//			foreach(DataTable dtAGTResults in dsPatientTestResults.Tables)
//			{
//				//find only tables that contain antigen typing results
//				if (dtAGTResults.TableName.Substring(0,2) == "AG")
//				{
					//determining the number of racklots to be created
					//if the test is WeakD one or two RackLots are being created (AntiD and optionally AntiDControl)
					//if there are no QC rows needed only one RackLot is being created (for a main reagent used for testing)
					//if there are QC rows needed four RackLots are being created (two for main reagent - pos and neg QC, one for pos control and one for neg control)
					if (System.Convert.ToInt32(dtAGTResults.Rows[0][TABLE.BloodTestType.OrderableTestId]) == (int)Common.OrderableTest.AGwD ||
						System.Convert.ToInt32(dtAGTResults.Rows[0][TABLE.BloodTestType.OrderableTestId]) == (int)Common.OrderableTest.RepeatAGwD)
					{
						dtQCResults = OrderedTest.GetQCResultsForOrderedTest((Guid)dtAGTResults.Rows[0][TABLE.SpecimenTest.OrderedTestGuid]);
						RackLotCount = dtAGTResults.Rows.Count;
					}
					else if (dtAGTResults.Rows.Count == 1)
					{
						dtQCResults = OrderedTest.GetQCResultsForOrderedTest((Guid)dtAGTResults.Rows[0][TABLE.SpecimenTest.OrderedTestGuid]);
						RackLotCount = 1;
					}
					else if (dtAGTResults.Rows.Count == 3)
					{
						dtQCResults = OrderedTest.GetQCResultsForOrderedTest((Guid)dtAGTResults.Rows[2][TABLE.SpecimenTest.OrderedTestGuid]);
						RackLotCount = 2;
					}

					//create racklots for testing reagents and pos, neg controls
					for (int i=0; i<RackLotCount ; i++)
					{
						//checking if the RackLot for this reagent already exists
						if (dtQCResults.Select("ReagentGuid = '" + dtAGTResults.Rows[i][TABLE.RackLot.ReagentGuid].ToString() + "' AND RecordStatusCode = 'A'").Length == 0)
						{
							//rack lot for POS and NEG controls
							drRackLot = dtRackLots.NewRow();

							drRackLot[TABLE.RackLot.RackLotGuid] = Guid.NewGuid();
							drRackLot[TABLE.RackLot.ReagentGuid] = dtAGTResults.Rows[i][TABLE.RackLot.ReagentGuid];
							drRackLot[TABLE.RackLot.LotUseDate] = testingDateTime;
							drRackLot[TABLE.RackLot.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
							drRackLot[TABLE.RackLot.LastUpdateUser] = Common.LogonUser.LogonUserName;
							drRackLot[TABLE.ReagentType.ReactivityPhaseCode] = dtAGTResults.Rows[i][TABLE.ReagentType.ReactivityPhaseCode];
							if (i == 0)
								drRackLot[TABLE.RackLot.ControlCellId] = true;	//POS
							else
								drRackLot[TABLE.RackLot.ControlCellId] = false;	//NEG
							drRackLot[TABLE.RackLot.LotVialNumber] = dtAGTResults.Rows[i][ARTIFICIAL.VialId];

							dtRackLots.Rows.Add(drRackLot);

							drAntiseraOrderedTest = dtAntiseraOrderedTests.NewRow();
							drAntiseraOrderedTest[TABLE.AntiseraOrderedTest.AntiseraOrderedTestGuid] = Guid.NewGuid();
							drAntiseraOrderedTest[TABLE.AntiseraOrderedTest.RackLotGuid] = drRackLot[TABLE.RackLot.RackLotGuid];

							if (dtAGTResults.Rows.Count == 1)
							{
								drAntiseraOrderedTest[TABLE.AntiseraOrderedTest.OrderedTestGuid] = dtAGTResults.Rows[0][TABLE.SpecimenTest.OrderedTestGuid];
							}
							else if (dtAGTResults.Rows.Count == 2)
							{
								drAntiseraOrderedTest[TABLE.AntiseraOrderedTest.OrderedTestGuid] = dtAGTResults.Rows[1][TABLE.SpecimenTest.OrderedTestGuid];
							}
							else if (dtAGTResults.Rows.Count == 3)
							{
								drAntiseraOrderedTest[TABLE.AntiseraOrderedTest.OrderedTestGuid] = dtAGTResults.Rows[2][TABLE.SpecimenTest.OrderedTestGuid];
							}
							
							drAntiseraOrderedTest[TABLE.AntiseraOrderedTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
							drAntiseraOrderedTest[TABLE.AntiseraOrderedTest.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active);
							dtAntiseraOrderedTests.Rows.Add(drAntiseraOrderedTest);
						}
						else
						{
							drRackLot = dtRackLots.NewRow();

							if (i == 0)
							{
								drRackLot[TABLE.RackLot.RackLotGuid] = (Guid)dtQCResults.Select("ReagentGuid = '" + dtAGTResults.Rows[i][TABLE.RackLot.ReagentGuid].ToString() + "' AND ControlCellId = 1")[0][TABLE.RackLot.RackLotGuid];
								drRackLot[TABLE.RackLot.RowVersion] = (byte[])dtQCResults.Select("ReagentGuid = '" + dtAGTResults.Rows[i][TABLE.RackLot.ReagentGuid].ToString() + "' AND ControlCellId = 1")[0][TABLE.RackLot.RowVersion];
							}
							else if (i == 1)
							{
								drRackLot[TABLE.RackLot.RackLotGuid] = (Guid)dtQCResults.Select("ReagentGuid = '" + dtAGTResults.Rows[i][TABLE.RackLot.ReagentGuid].ToString() + "' AND ControlCellId = 0")[0][TABLE.RackLot.RackLotGuid];
								drRackLot[TABLE.RackLot.RowVersion] = (byte[])dtQCResults.Select("ReagentGuid = '" + dtAGTResults.Rows[i][TABLE.RackLot.ReagentGuid].ToString() + "' AND ControlCellId = 0")[0][TABLE.RackLot.RowVersion];
							}

							drRackLot[TABLE.RackLot.LotUseDate] = testingDateTime;
							drRackLot[TABLE.RackLot.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
							drRackLot[TABLE.RackLot.LastUpdateUser] = Common.LogonUser.LogonUserName;
							if (i == 0)
								drRackLot[TABLE.RackLot.ControlCellId] = true;	//POS
							else
								drRackLot[TABLE.RackLot.ControlCellId] = false;	//NEG
							drRackLot[TABLE.RackLot.LotVialNumber] = dtAGTResults.Rows[i][ARTIFICIAL.VialId];
							drRackLot[TABLE.RackLot.Comments] = dtAGTResults.Rows[i][ARTIFICIAL.Comment];

							dtRackLots.Rows.Add(drRackLot);
						}

						//save qc test results and pos/neg controls if the test is not WeakD and the are qc rows present on the datagrid
						if (RackLotCount == 2 &&
							System.Convert.ToInt32(dtAGTResults.Rows[0][TABLE.BloodTestType.OrderableTestId]) != (int)Common.OrderableTest.AGwD &&
							System.Convert.ToInt32(dtAGTResults.Rows[0][TABLE.BloodTestType.OrderableTestId]) != (int)Common.OrderableTest.RepeatAGwD)
						{
							//rack lot for speciment test
							drRackLot = dtRackLots.NewRow();

							if (dtQCResults.Select("ReagentGuid = '" + dtAGTResults.Rows[2][TABLE.RackLot.ReagentGuid].ToString() + "' AND RecordStatusCode = 'A'").Length == 0)
							{
								drRackLot[TABLE.RackLot.RackLotGuid] = Guid.NewGuid();

								drAntiseraOrderedTest = dtAntiseraOrderedTests.NewRow();
								drAntiseraOrderedTest[TABLE.AntiseraOrderedTest.AntiseraOrderedTestGuid] = Guid.NewGuid();
								drAntiseraOrderedTest[TABLE.AntiseraOrderedTest.RackLotGuid] = drRackLot[TABLE.RackLot.RackLotGuid];
								drAntiseraOrderedTest[TABLE.AntiseraOrderedTest.OrderedTestGuid] = dtAGTResults.Rows[2][TABLE.SpecimenTest.OrderedTestGuid];
								drAntiseraOrderedTest[TABLE.AntiseraOrderedTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
								drAntiseraOrderedTest[TABLE.AntiseraOrderedTest.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active);
								dtAntiseraOrderedTests.Rows.Add(drAntiseraOrderedTest);
							}
							else
							{
								if (i == 0)
								{
									drRackLot[TABLE.RackLot.RackLotGuid] = (Guid)dtQCResults.Select("ReagentGuid = '" + dtAGTResults.Rows[2][TABLE.RackLot.ReagentGuid].ToString() + "' AND ControlCellId = 1")[0][TABLE.RackLot.RackLotGuid];
									drRackLot[TABLE.RackLot.RowVersion] = (byte[])dtQCResults.Select("ReagentGuid = '" + dtAGTResults.Rows[2][TABLE.RackLot.ReagentGuid].ToString() + "' AND ControlCellId = 1")[0][TABLE.RackLot.RowVersion];
								}
								else if (i == 1)
								{
									drRackLot[TABLE.RackLot.RackLotGuid] = (Guid)dtQCResults.Select("ReagentGuid = '" + dtAGTResults.Rows[2][TABLE.RackLot.ReagentGuid].ToString() + "' AND ControlCellId = 0")[0][TABLE.RackLot.RackLotGuid];
									drRackLot[TABLE.RackLot.RowVersion] = (byte[])dtQCResults.Select("ReagentGuid = '" + dtAGTResults.Rows[2][TABLE.RackLot.ReagentGuid].ToString() + "' AND ControlCellId = 0")[0][TABLE.RackLot.RowVersion];
								}
							}

							drRackLot[TABLE.RackLot.RackGuid] = dtAGTResults.Rows[0][TABLE.Rack.RackGuid];
							drRackLot[TABLE.RackLot.ReagentGuid] = dtAGTResults.Rows[2][TABLE.RackLot.ReagentGuid];
							drRackLot[TABLE.RackLot.TestWithId] = dtAGTResults.Rows[i][TABLE.ReagentType.ReagentTypeId];

							drRackLot[TABLE.ReagentType.ReactivityPhaseCode] = dtAGTResults.Rows[i][TABLE.ReagentType.ReactivityPhaseCode];

							drRackLot[TABLE.RackLot.LotUseDate] = testingDateTime;
							drRackLot[TABLE.RackLot.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
							drRackLot[TABLE.RackLot.LastUpdateUser] = Common.LogonUser.LogonUserName;
							if (i == 0)
								drRackLot[TABLE.RackLot.ControlCellId] = true;	//POS
							else
								drRackLot[TABLE.RackLot.ControlCellId] = false;	//NEG
							drRackLot[TABLE.RackLot.LotVialNumber] = dtAGTResults.Rows[2][ARTIFICIAL.VialId];
							drRackLot[TABLE.RackLot.Comments] = dtAGTResults.Rows[i][ARTIFICIAL.Comment];

							Interp = dtAGTResults.Rows[i][ARTIFICIAL.Interp].ToString();

							if ((Interp == "P" && i == 0) ||
								(Interp == "N" && i == 1))
							{
								drRackLot[TABLE.RackLot.SatisfactoryResultIndicator] = true;
							}
							else if ((Interp == "N" && i == 0) ||
								(Interp == "P" && i == 1))
							{
								drRackLot[TABLE.RackLot.SatisfactoryResultIndicator] = false;
							}

							dtRackLots.Rows.Add(drRackLot);

							DataRow drRackTest = null;
							bool update = false;

							foreach(DataColumn col in dtAGTResults.Columns)
							{
								if (col.ColumnName == ARTIFICIAL.IS || col.ColumnName == ARTIFICIAL.C37 || col.ColumnName == ARTIFICIAL.RT ||
									col.ColumnName == ARTIFICIAL.AHG || col.ColumnName == ARTIFICIAL.CC)
								{
									if (dtAGTResults.Rows[i].IsNull(col) == false)
									{
										string colSave = col.ColumnName + "Save";
										string colGuid = col.ColumnName + ARTIFICIAL.Guid;
										string colRowVersion = col.ColumnName + TABLE.BloodUnit.RowVersion;

										if ((bool)dtAGTResults.Rows[i][colSave] == false)
											continue;

										if (dtAGTResults.Rows[i].IsNull(colGuid) == true)
										{
											drRackTest = dtRackTestsInsert.NewRow();
											drRackTest[TABLE.RackTest.RackTestGuid] = Guid.NewGuid();
											dtRackTestsInsert.Rows.Add(drRackTest);
											update = false;
										}
										else
										{
											drRackTest = dtRackTestsUpdate.NewRow();
											drRackTest[TABLE.RackTest.RackTestGuid] = dtAGTResults.Rows[i][colGuid];
											drRackTest[TABLE.RackTest.RowVersion] = dtAGTResults.Rows[i][colRowVersion];
											dtRackTestsUpdate.Rows.Add(drRackTest);
											update = true;
										}

										if (update == false)
										{
											drRackTest[TABLE.RackTest.RackLotGuid] = drRackLot[TABLE.RackLot.RackLotGuid];
										}

										drRackTest[TABLE.RackTest.TestDate] = testingDateTime;
										drRackTest[TABLE.RackTest.TestTechId] = testingUser;
										drRackTest[TABLE.RackTest.RecordStatusCode] = "A";
										drRackTest[TABLE.RackTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
										drRackTest[TABLE.RackTest.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;

										if (dtAGTResults.Rows[i][col].ToString().Trim() != "")
											drRackTest[TABLE.RackTest.RackTestResult] = dtAGTResults.Rows[i][col];
										else
											drRackTest[TABLE.RackTest.RackTestResult] = DBNull.Value;

										if (col.ColumnName == ARTIFICIAL.IS)
										{
											if ((bool)dtAGTResults.Rows[i][ARTIFICIAL.ISSave] == true)
											{
												if (update == false)
													drRackTest[TABLE.RackTest.RackTestResultTypeCode] = ARTIFICIAL.IS;
											}
										}
										else if (col.ColumnName == ARTIFICIAL.RT)
										{
											if ((bool)dtAGTResults.Rows[i][ARTIFICIAL.RTSave] == true)
											{
												if (update == false)
													drRackTest[TABLE.RackTest.RackTestResultTypeCode] = ARTIFICIAL.RT;
											}
										}
										else if (col.ColumnName == ARTIFICIAL.C37)
										{
											if ((bool)dtAGTResults.Rows[i][ARTIFICIAL.C37Save] == true)
											{
												if (update == false)
													drRackTest[TABLE.RackTest.RackTestResultTypeCode] = ARTIFICIAL.C37;
											}
										}
										else if (col.ColumnName == ARTIFICIAL.AHG)
										{
											if ((bool)dtAGTResults.Rows[i][ARTIFICIAL.AHGSave] == true)
											{
												if (update == false)
													drRackTest[TABLE.RackTest.RackTestResultTypeCode] = ARTIFICIAL.AHG;
											}
										}
										else if (col.ColumnName == ARTIFICIAL.CC)
										{
											if ((bool)dtAGTResults.Rows[i][ARTIFICIAL.CCSave] == true)
											{
												if (update == false)
													drRackTest[TABLE.RackTest.RackTestResultTypeCode] = ARTIFICIAL.CC;
											}
										}
									}
								}
							}
						}
					}
//				}
//			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/28/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2836"> 
		///		<ExpectedInput>Output DataTable containing ABO/Rh test results, OrderedTest identifier, OrderableTestId</ExpectedInput>
		///		<ExpectedOutput>DataTable containing ABO/Rh test results</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2837"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Load previously entered test results into ABORh row that drives the datagrid
		/// </summary>
		/// <param name="drABORh"></param>
		/// <param name="orderedTestGuid"></param>
		/// <param name="orderableTestId"></param>
		public static void BuildABORhFromSpecimenTest(DataRow drABORh, Guid orderedTestGuid, 
														string orderableTestId)
		{
			string BloodTestType = "";
			DataTable dtBloodTestTypes = BOL.BloodTestType.GetBloodTestTypes(orderableTestId);
			DataTable dtSpecimenTests = DAL.OrderedTest.GetTestResultsForTask(orderedTestGuid);

			//if (dtSpecimenTests.Select("BloodTestName LIKE '*Anti A*'").Length == 0)
			//CRT - 101405 - If its Transfusion-Only - we won't have an Anti A, so we should look for interp instead??
			if (dtSpecimenTests.Select("BloodTestName LIKE 'ABO Interp'").Length == 0)
				return;

			foreach(DataRow drSpecimenTest in dtSpecimenTests.Rows)
			{
				if (drSpecimenTest.IsNull(TABLE.SpecimenTest.CorrectedResultIndicator))
				{
					drABORh[TABLE.SpecimenTest.CorrectedResultIndicator] = false;
				}
				else
				{
					drABORh[TABLE.SpecimenTest.CorrectedResultIndicator] = (bool)drSpecimenTest[TABLE.SpecimenTest.CorrectedResultIndicator];
				}

				if (drSpecimenTest.IsNull(TABLE.SpecimenTest.AboRhChangeIndicator) == false)
				{
					if ((bool)drSpecimenTest[TABLE.SpecimenTest.AboRhChangeIndicator] == true)
					{
						drABORh[TABLE.SpecimenTest.AboRhChangeIndicator] = true;
					}
				}

				BloodTestType = dtBloodTestTypes.Select("BloodTestTypeId = '" + drSpecimenTest[TABLE.SpecimenTest.BloodTestTypeId].ToString() + "'")[0][TABLE.BloodTestType.BloodTestName].ToString();
				if (BloodTestType.IndexOf("Anti A,B") != -1)
				{
					if (drSpecimenTest.IsNull(TABLE.SpecimenTest.TestResultId) == false)
					{
						drABORh["AntiAB"] = drSpecimenTest[TABLE.SpecimenTest.TestResultId].ToString().Trim();
						drABORh["AntiABSave"] = false;
					}
					else
					{
						drABORh["AntiAB"] = "";
						drABORh["AntiABSave"] = true;
					}
					drABORh[ARTIFICIAL.AboComment] = drSpecimenTest[TABLE.SpecimenTest.TestComments];
					drABORh["AntiABGuid"] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];
					drABORh["AntiABRowVersion"] = drSpecimenTest[TABLE.SpecimenTest.RowVersion];
				}
				else if (BloodTestType.IndexOf("Anti A") != -1)
				{
					if (drSpecimenTest.IsNull(TABLE.SpecimenTest.TestResultId) == false)
					{
						drABORh["AntiA"] = drSpecimenTest[TABLE.SpecimenTest.TestResultId].ToString().Trim();
						drABORh["AntiASave"] = false;
					}
					else
					{
						drABORh["AntiA"] = "";
						drABORh["AntiASave"] = true;
					}
					drABORh[ARTIFICIAL.AboComment] = drSpecimenTest[TABLE.SpecimenTest.TestComments];
					drABORh["AntiAGuid"] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];
					drABORh["AntiARowVersion"] = drSpecimenTest[TABLE.SpecimenTest.RowVersion];
				}
				else if (BloodTestType.IndexOf("Anti B") != -1)
				{
					if (drSpecimenTest.IsNull(TABLE.SpecimenTest.TestResultId) == false)
					{
						drABORh["AntiB"] = drSpecimenTest[TABLE.SpecimenTest.TestResultId].ToString().Trim();
						drABORh["AntiBSave"] = false;
					}
					else
					{
						drABORh["AntiB"] = "";
						drABORh["AntiBSave"] = true;
					}
					drABORh[ARTIFICIAL.AboComment] = drSpecimenTest[TABLE.SpecimenTest.TestComments];
					drABORh["AntiBGuid"] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];
					drABORh["AntiBRowVersion"] = drSpecimenTest[TABLE.SpecimenTest.RowVersion];
				}
				else if (BloodTestType.IndexOf("A1 Cells") != -1)
				{
					if (drSpecimenTest.IsNull(TABLE.SpecimenTest.TestResultId) == false)
					{
						drABORh["A1Cells"] = drSpecimenTest[TABLE.SpecimenTest.TestResultId].ToString().Trim();
						drABORh["A1CellsSave"] = false;
					}
					else
					{
						drABORh["A1Cells"] = "";
						drABORh["A1CellsSave"] = true;
					}
					drABORh[ARTIFICIAL.AboComment] = drSpecimenTest[TABLE.SpecimenTest.TestComments];
					drABORh["A1CellsGuid"] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];
					drABORh["A1CellsRowVersion"] = drSpecimenTest[TABLE.SpecimenTest.RowVersion];
				}
				else if (BloodTestType.IndexOf("B Cells") != -1)
				{
					if (drSpecimenTest.IsNull(TABLE.SpecimenTest.TestResultId) == false)
					{
						drABORh["BCells"] = drSpecimenTest[TABLE.SpecimenTest.TestResultId].ToString().Trim();
						drABORh["BCellsSave"] = false;
					}
					else
					{
						drABORh["BCells"] = "";
						drABORh["BCellsSave"] = true;
					}
					drABORh[ARTIFICIAL.AboComment] = drSpecimenTest[TABLE.SpecimenTest.TestComments];
					drABORh["BCellsGuid"] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];
					drABORh["BCellsRowVersion"] = drSpecimenTest[TABLE.SpecimenTest.RowVersion];
				}
				else if (BloodTestType.IndexOf("ABO Interp") != -1)
				{
					if (drSpecimenTest.IsNull(TABLE.SpecimenTest.TestResultId) == false)
					{
						drABORh["AboInterp"] = drSpecimenTest[TABLE.SpecimenTest.TestResultId].ToString().Trim();
						drABORh["AboInterpSave"] = false;
					}
					else
					{
						drABORh["AboInterp"] = "";
						drABORh["AboInterpSave"] = true;
					}
					drABORh[ARTIFICIAL.AboComment] = drSpecimenTest[TABLE.SpecimenTest.TestComments];
					drABORh["AboInterpGuid"] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];
					drABORh["AboInterpRowVersion"] = drSpecimenTest[TABLE.SpecimenTest.RowVersion];
				}
				else if (BloodTestType.IndexOf("Anti D") != -1)
				{
					if (drSpecimenTest.IsNull(TABLE.SpecimenTest.TestResultId) == false)
					{
						drABORh["AntiD"] = drSpecimenTest[TABLE.SpecimenTest.TestResultId].ToString().Trim();
						drABORh["AntiDSave"] = false;
					}
					else
					{
						drABORh["AntiD"] = "";
						drABORh["AntiDSave"] = true;
					}
					drABORh[ARTIFICIAL.RhComment] = drSpecimenTest[TABLE.SpecimenTest.TestComments];
					drABORh["AntiDGuid"] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];
					drABORh["AntiDRowVersion"] = drSpecimenTest[TABLE.SpecimenTest.RowVersion];
				}
				else if (BloodTestType.IndexOf("D Control") != -1)
				{
					if (drSpecimenTest.IsNull(TABLE.SpecimenTest.TestResultId) == false)
					{
						drABORh["ControlD"] = drSpecimenTest[TABLE.SpecimenTest.TestResultId].ToString().Trim();
						drABORh["ControlDSave"] = false;
					}
					else
					{
						drABORh["ControlD"] = "";
						drABORh["ControlDSave"] = true;
					}
					drABORh[ARTIFICIAL.RhComment] = drSpecimenTest[TABLE.SpecimenTest.TestComments];
					drABORh["ControlDGuid"] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];
					drABORh["ControlDRowVersion"] = drSpecimenTest[TABLE.SpecimenTest.RowVersion];
				}
				else if (BloodTestType.IndexOf("Rh Interp") != -1)
				{
					if (drSpecimenTest.IsNull(TABLE.SpecimenTest.TestResultId) == false)
					{
						drABORh["RhInterp"] = drSpecimenTest[TABLE.SpecimenTest.TestResultId].ToString().Trim();
						drABORh["RhInterpSave"] = false;
					}
					else
					{
						drABORh["RhInterp"] = "";
						drABORh["RhInterpSave"] = true;
					}
					drABORh[ARTIFICIAL.RhComment] = drSpecimenTest[TABLE.SpecimenTest.TestComments];
					drABORh["RhInterpGuid"] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];
					drABORh["RhInterpRowVersion"] = drSpecimenTest[TABLE.SpecimenTest.RowVersion];
				}

				if (drSpecimenTest.IsNull(TABLE.Rack.RackGuid) == false)
					drABORh[TABLE.Rack.RackGuid] = (Guid)drSpecimenTest[TABLE.Rack.RackGuid];
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/28/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2838"> 
		///		<ExpectedInput>Output DataTable containing DAT test results, OrderedTest identifier, OrderableTestId</ExpectedInput>
		///		<ExpectedOutput>DataTable containing DAT test results</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2839"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Load previously entered test results into DAT row that drives the datagrid
		/// </summary>
		/// <param name="dtDAT"></param>
		/// <param name="orderedTestGuid"></param>
		/// <param name="orderableTestId"></param>
		public static void BuildDATFromSpecimenTest(DataTable dtDAT, Guid orderedTestGuid, 
													string orderableTestId)
		{
			string BloodTestType = "";
			DataTable dtBloodTestTypes = BOL.BloodTestType.GetBloodTestTypes(orderableTestId);
			DataTable dtSpecimenTests = DAL.OrderedTest.GetTestResultsForTask(orderedTestGuid);

			if (dtSpecimenTests.Select("BloodTestName LIKE '*DAT*'").Length == 0)
				return;

			foreach(DataRow drSpecimenTest in dtSpecimenTests.Rows)
			{
				if (dtBloodTestTypes.Select("BloodTestTypeId = '" + drSpecimenTest[TABLE.SpecimenTest.BloodTestTypeId].ToString() + "'").Length > 0)
				{
					BloodTestType = dtBloodTestTypes.Select("BloodTestTypeId = '" + drSpecimenTest[TABLE.SpecimenTest.BloodTestTypeId].ToString() + "'")[0][TABLE.BloodTestType.BloodTestName].ToString();
				}
				else
				{
					continue;
				}

				if (BloodTestType.IndexOf("Poly") != -1)
				{
					if (BloodTestType.IndexOf(ARTIFICIAL.AHG) != -1)
					{
						if (drSpecimenTest.IsNull(TABLE.SpecimenTest.TestResultId) == false)
						{
							dtDAT.Rows[0][ARTIFICIAL.AHG] = drSpecimenTest[TABLE.SpecimenTest.TestResultId].ToString().Trim();
							dtDAT.Rows[0][ARTIFICIAL.AHGSave] = false;
						}
						else
						{
							dtDAT.Rows[0][ARTIFICIAL.AHG] = "";
							dtDAT.Rows[0][ARTIFICIAL.AHGSave] = true;
						}
						dtDAT.Rows[0][ARTIFICIAL.AHGComment] = drSpecimenTest[TABLE.SpecimenTest.TestComments];
						dtDAT.Rows[0][ARTIFICIAL.AHGGuid] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];
						dtDAT.Rows[0][ARTIFICIAL.AHGRowVersion] = drSpecimenTest[TABLE.SpecimenTest.RowVersion];
					}
					else if (BloodTestType.IndexOf(ARTIFICIAL.CC) != -1)
					{
						if (drSpecimenTest.IsNull(TABLE.SpecimenTest.TestResultId) == false)
						{
							dtDAT.Rows[0][ARTIFICIAL.CC] = drSpecimenTest[TABLE.SpecimenTest.TestResultId].ToString().Trim();
							dtDAT.Rows[0][ARTIFICIAL.CCSave] = false;
						}
						else
						{
							dtDAT.Rows[0][ARTIFICIAL.CC] = "";
							dtDAT.Rows[0][ARTIFICIAL.CCSave] = true;
						}
						dtDAT.Rows[0][ARTIFICIAL.AHGComment] = drSpecimenTest[TABLE.SpecimenTest.TestComments];
						dtDAT.Rows[0][ARTIFICIAL.CCGuid] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];
						dtDAT.Rows[0][ARTIFICIAL.CCRowVersion] = drSpecimenTest[TABLE.SpecimenTest.RowVersion];
					}
					else if (BloodTestType.IndexOf(ARTIFICIAL.Interp) != -1)
					{
						if (drSpecimenTest.IsNull(TABLE.SpecimenTest.TestResultId) == false)
						{
							dtDAT.Rows[0][ARTIFICIAL.AHGInterp] = drSpecimenTest[TABLE.SpecimenTest.TestResultId].ToString().Trim();
							dtDAT.Rows[0][ARTIFICIAL.AHGInterpSave] = false;
						}
						else
						{
							dtDAT.Rows[0][ARTIFICIAL.AHGInterp] = "";
							dtDAT.Rows[0][ARTIFICIAL.AHGInterpSave] = true;
						}
						dtDAT.Rows[0][ARTIFICIAL.AHGComment] = drSpecimenTest[TABLE.SpecimenTest.TestComments];
						dtDAT.Rows[0]["AHGInterpGuid"] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];
						dtDAT.Rows[0]["AHGInterpRowVersion"] = drSpecimenTest[TABLE.SpecimenTest.RowVersion];
					}
				}
				else if (BloodTestType.IndexOf(ARTIFICIAL.IgG) != -1)
				{
					if (BloodTestType.IndexOf(ARTIFICIAL.AHG) != -1)
					{
						if (drSpecimenTest.IsNull(TABLE.SpecimenTest.TestResultId) == false)
						{
							dtDAT.Rows[0][ARTIFICIAL.IgG] = drSpecimenTest[TABLE.SpecimenTest.TestResultId].ToString().Trim();
							dtDAT.Rows[0][ARTIFICIAL.IgGSave] = false;
						}
						else
						{
							dtDAT.Rows[0][ARTIFICIAL.IgG] = "";
							dtDAT.Rows[0][ARTIFICIAL.IgGSave] = true;
						}
						dtDAT.Rows[0][ARTIFICIAL.IgGComment] = drSpecimenTest[TABLE.SpecimenTest.TestComments];
						dtDAT.Rows[0][ARTIFICIAL.IgGGuid] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];
						dtDAT.Rows[0][ARTIFICIAL.IgGRowVersion] = drSpecimenTest[TABLE.SpecimenTest.RowVersion];
					}
					else if (BloodTestType.IndexOf(ARTIFICIAL.CC) != -1)
					{
						if (drSpecimenTest.IsNull(TABLE.SpecimenTest.TestResultId) == false)
						{
							dtDAT.Rows[0][ARTIFICIAL.CC] = drSpecimenTest[TABLE.SpecimenTest.TestResultId].ToString().Trim();
							dtDAT.Rows[0][ARTIFICIAL.CCSave] = false;
						}
						else
						{
							dtDAT.Rows[0][ARTIFICIAL.CC] = "";
							dtDAT.Rows[0][ARTIFICIAL.CCSave] = true;
						}
						dtDAT.Rows[0][ARTIFICIAL.IgGComment] = drSpecimenTest[TABLE.SpecimenTest.TestComments];
						dtDAT.Rows[0][ARTIFICIAL.CCGuid] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];
						dtDAT.Rows[0][ARTIFICIAL.CCRowVersion] = drSpecimenTest[TABLE.SpecimenTest.RowVersion];
					}
					else if (BloodTestType.IndexOf(ARTIFICIAL.Interp) != -1)
					{
						if (drSpecimenTest.IsNull(TABLE.SpecimenTest.TestResultId) == false)
						{
							dtDAT.Rows[0][ARTIFICIAL.IgGInterp] = drSpecimenTest[TABLE.SpecimenTest.TestResultId].ToString().Trim();
							dtDAT.Rows[0][ARTIFICIAL.IgGInterpSave] = false;
						}
						else
						{
							dtDAT.Rows[0][ARTIFICIAL.IgGInterp] = "";
							dtDAT.Rows[0][ARTIFICIAL.IgGInterpSave] = true;
						}
						dtDAT.Rows[0][ARTIFICIAL.IgGComment] = drSpecimenTest[TABLE.SpecimenTest.TestComments];
						dtDAT.Rows[0]["IgGInterpGuid"] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];
						dtDAT.Rows[0]["IgGInterpRowVersion"] = drSpecimenTest[TABLE.SpecimenTest.RowVersion];
					}
				}
				else if (BloodTestType.IndexOf("Comp") != -1)
				{
					if (BloodTestType.IndexOf(ARTIFICIAL.AHG) != -1)
					{
						if (drSpecimenTest.IsNull(TABLE.SpecimenTest.TestResultId) == false)
						{
							dtDAT.Rows[0][ARTIFICIAL.C3d] = drSpecimenTest[TABLE.SpecimenTest.TestResultId].ToString().Trim();
							dtDAT.Rows[0][ARTIFICIAL.C3dSave] = false;
						}
						else
						{
							dtDAT.Rows[0][ARTIFICIAL.C3d] = "";
							dtDAT.Rows[0][ARTIFICIAL.C3dSave] = true;
						}
						dtDAT.Rows[0][ARTIFICIAL.C3dComment] = drSpecimenTest[TABLE.SpecimenTest.TestComments];
						dtDAT.Rows[0][ARTIFICIAL.C3dGuid] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];
						dtDAT.Rows[0][ARTIFICIAL.C3dRowVersion] = drSpecimenTest[TABLE.SpecimenTest.RowVersion];
					}
					else if (BloodTestType.IndexOf(ARTIFICIAL.CC) != -1)
					{
						if (drSpecimenTest.IsNull(TABLE.SpecimenTest.TestResultId) == false)
						{
							dtDAT.Rows[0][ARTIFICIAL.CC] = drSpecimenTest[TABLE.SpecimenTest.TestResultId].ToString().Trim();
							dtDAT.Rows[0][ARTIFICIAL.CCSave] = false;
						}
						else
						{
							dtDAT.Rows[0][ARTIFICIAL.CC] = "";
							dtDAT.Rows[0][ARTIFICIAL.CCSave] = true;
						}
						dtDAT.Rows[0][ARTIFICIAL.C3dComment] = drSpecimenTest[TABLE.SpecimenTest.TestComments];
						dtDAT.Rows[0][ARTIFICIAL.CCGuid] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];
						dtDAT.Rows[0][ARTIFICIAL.CCRowVersion] = drSpecimenTest[TABLE.SpecimenTest.RowVersion];
					}
					else if (BloodTestType.IndexOf(ARTIFICIAL.Interp) != -1)
					{
						if (drSpecimenTest.IsNull(TABLE.SpecimenTest.TestResultId) == false)
						{
							dtDAT.Rows[0][ARTIFICIAL.C3dInterp] = drSpecimenTest[TABLE.SpecimenTest.TestResultId].ToString().Trim();
							dtDAT.Rows[0][ARTIFICIAL.C3dInterpSave] = false;
						}
						else
						{
							dtDAT.Rows[0][ARTIFICIAL.C3dInterp] = "";
							dtDAT.Rows[0][ARTIFICIAL.C3dInterpSave] = true;
						}
						dtDAT.Rows[0][ARTIFICIAL.C3dComment] = drSpecimenTest[TABLE.SpecimenTest.TestComments];
						dtDAT.Rows[0]["C3dInterpGuid"] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];
						dtDAT.Rows[0]["C3dInterpRowVersion"] = drSpecimenTest[TABLE.SpecimenTest.RowVersion];
					}
				}

				if (drSpecimenTest.IsNull(TABLE.SpecimenTest.CorrectedResultIndicator))
				{
					dtDAT.Rows[0][TABLE.SpecimenTest.CorrectedResultIndicator] = false;
				}
				else
				{
					dtDAT.Rows[0][TABLE.SpecimenTest.CorrectedResultIndicator] = (bool)drSpecimenTest[TABLE.SpecimenTest.CorrectedResultIndicator];
				}
				if (drSpecimenTest.IsNull(TABLE.Rack.RackGuid) == false)
					dtDAT.Rows[0][TABLE.Rack.RackGuid] = (Guid)drSpecimenTest[TABLE.Rack.RackGuid];
			}

			DataTable dtQCResults = OrderedTest.GetQCResultsForOrderedTest(orderedTestGuid);

			if (dtQCResults.Rows.Count > 0)
			{
				if (orderableTestId == ((int)Common.OrderableTest.DAT).ToString() ||
					orderableTestId == ((int)Common.OrderableTest.RepeatDAT).ToString() ||
					orderableTestId == ((int)Common.OrderableTest.TAS).ToString() ||
					orderableTestId == ((int)Common.OrderableTest.ABS).ToString() ||
					orderableTestId == ((int)Common.OrderableTest.RepeatABS).ToString())
				{
					DataRow drPSAHG = dtQCResults.Select("ReagentTypeId = " + (int)Common.DATTestControls.PSDAT + " AND (RecordStatusCode = 'A' OR RecordStatusCode IS NULL)")[0];
					dtDAT.Rows[0][TABLE.Reagent.LotNumber] = drPSAHG[TABLE.Reagent.LotNumber];
					dtDAT.Rows[0]["LotNumberSave"] = false;
					dtDAT.Rows[0][TABLE.RackLot.ReagentGuid] = drPSAHG[TABLE.RackLot.ReagentGuid];
					dtDAT.Rows[0][TABLE.ReagentType.ReagentTypeId] = drPSAHG[TABLE.ReagentType.ReagentTypeId];
					dtDAT.Rows[0]["Manufacturer"] = drPSAHG[TABLE.Reagent.ReagentManufacturerName];
					dtDAT.Rows[0]["ExpirationDate"] = drPSAHG[TABLE.Reagent.LotExpirationDate];
				}
				else if (orderableTestId == ((int)Common.OrderableTest.DATIgG).ToString() ||
						 orderableTestId == ((int)Common.OrderableTest.RepeatDATIgG).ToString())
				{
					DataRow drIgG = dtQCResults.Select("ReagentTypeId = " + (int)Common.DATTestControls.IgGDAT + " AND (RecordStatusCode = 'A' OR RecordStatusCode IS NULL)")[0];
					dtDAT.Rows[0][TABLE.Reagent.LotNumber] = drIgG[TABLE.Reagent.LotNumber];
					dtDAT.Rows[0]["LotNumberSave"] = false;
					dtDAT.Rows[0][TABLE.RackLot.ReagentGuid] = drIgG[TABLE.RackLot.ReagentGuid];
					dtDAT.Rows[0][TABLE.ReagentType.ReagentTypeId] = drIgG[TABLE.ReagentType.ReagentTypeId];
					dtDAT.Rows[0]["Manufacturer"] = drIgG[TABLE.Reagent.ReagentManufacturerName];
					dtDAT.Rows[0]["ExpirationDate"] = drIgG[TABLE.Reagent.LotExpirationDate];
				}
				else if (orderableTestId == ((int)Common.OrderableTest.DATComp).ToString() ||
						 orderableTestId == ((int)Common.OrderableTest.RepeatDATComp).ToString())
				{
					DataRow drC3d = dtQCResults.Select("ReagentTypeId = " + (int)Common.DATTestControls.CompDAT + " AND (RecordStatusCode = 'A' OR RecordStatusCode IS NULL)")[0];
					dtDAT.Rows[0][TABLE.Reagent.LotNumber] = drC3d[TABLE.Reagent.LotNumber];
					dtDAT.Rows[0]["LotNumberSave"] = false;
					dtDAT.Rows[0][TABLE.RackLot.ReagentGuid] = drC3d[TABLE.RackLot.ReagentGuid];
					dtDAT.Rows[0][TABLE.ReagentType.ReagentTypeId] = drC3d[TABLE.ReagentType.ReagentTypeId];
					dtDAT.Rows[0]["Manufacturer"] = drC3d[TABLE.Reagent.ReagentManufacturerName];
					dtDAT.Rows[0]["ExpirationDate"] = drC3d[TABLE.Reagent.LotExpirationDate];
				}

				DataRow[] drControls = null;

				if (orderableTestId == ((int)Common.OrderableTest.DAT).ToString() ||
					orderableTestId == ((int)Common.OrderableTest.TAS).ToString() ||
					orderableTestId == ((int)Common.OrderableTest.ABS).ToString() ||
					orderableTestId == ((int)Common.OrderableTest.RepeatDAT).ToString() ||
					orderableTestId == ((int)Common.OrderableTest.RepeatABS).ToString())
				{
					drControls = dtQCResults.Select("ReagentTypeId <> " + (int)Common.DATTestControls.PSDAT + " AND (RecordStatusCode = 'A' OR RecordStatusCode IS NULL)", "ReagentTypeId DESC");
				}
				else if (orderableTestId == ((int)Common.OrderableTest.DATIgG).ToString() ||
						 orderableTestId == ((int)Common.OrderableTest.RepeatDATIgG).ToString())
				{
					drControls = dtQCResults.Select("ReagentTypeId <> " + (int)Common.DATTestControls.IgGDAT + " AND (RecordStatusCode = 'A' OR RecordStatusCode IS NULL)", "ReagentTypeId DESC");
				}
				else if (orderableTestId == ((int)Common.OrderableTest.DATComp).ToString() ||
						 orderableTestId == ((int)Common.OrderableTest.RepeatDATComp).ToString())
				{
					drControls = dtQCResults.Select("ReagentTypeId <> " + (int)Common.DATTestControls.CompDAT + " AND (RecordStatusCode = 'A' OR RecordStatusCode IS NULL)", "ReagentTypeId DESC");
				}

                //CR 3554
                if (drControls == null)
                    throw new ApplicationException("drControls is null");

				DataRow drDAT, drPos=null, drNeg=null;
				foreach(DataRow drControl in drControls)
				{
					drDAT = dtDAT.NewRow();
					drDAT[TABLE.PatientSpecimen.PatientGuid] = dtDAT.Rows[0][TABLE.PatientSpecimen.PatientGuid];
					drDAT[TABLE.SpecimenTest.PatientSpecimenGuid] = dtDAT.Rows[0][TABLE.SpecimenTest.PatientSpecimenGuid];
					drDAT[TABLE.SpecimenTest.OrderedTestGuid] = dtDAT.Rows[0][TABLE.SpecimenTest.OrderedTestGuid];
					drDAT[ARTIFICIAL.OrderedTestRowVersion] = dtDAT.Rows[0][ARTIFICIAL.OrderedTestRowVersion];
					drDAT[TABLE.BloodTestType.OrderableTestId] = dtDAT.Rows[0][TABLE.BloodTestType.OrderableTestId];
					drDAT[ARTIFICIAL.Indicator] = "";
					drDAT[TABLE.Reagent.LotNumber] = drControl[TABLE.Reagent.LotNumber];
					drDAT["Manufacturer"] = drControl[TABLE.Reagent.ReagentManufacturerName];
					drDAT["ExpirationDate"] = drControl[TABLE.Reagent.LotExpirationDate];
					drDAT["LotNumberSave"] = false;
					drDAT[TABLE.ReagentType.ReagentTypeId] = drControl[TABLE.ReagentType.ReagentTypeId];
					drDAT[TABLE.RackLot.ReagentGuid] = drControl[TABLE.RackLot.ReagentGuid];
					drDAT[ARTIFICIAL.PartiallyCompleted] = true;
					drDAT[TABLE.Rack.RackGuid] = dtDAT.Rows[0][TABLE.Rack.RackGuid];

					if (orderableTestId == ((int)Common.OrderableTest.DAT).ToString() ||
						orderableTestId == ((int)Common.OrderableTest.RepeatDAT).ToString() ||
						orderableTestId == ((int)Common.OrderableTest.TAS).ToString() ||
						orderableTestId == ((int)Common.OrderableTest.ABS).ToString() ||
						orderableTestId == ((int)Common.OrderableTest.RepeatABS).ToString())
					{
						drDAT[ARTIFICIAL.AHG] = "";
						drDAT[ARTIFICIAL.AHGInterp] = "";
						drDAT[ARTIFICIAL.AHGSave] = false;
						drDAT[ARTIFICIAL.AHGInterpSave] = true;
					}
					else if (orderableTestId == ((int)Common.OrderableTest.DATIgG).ToString() ||
							 orderableTestId == ((int)Common.OrderableTest.RepeatDATIgG).ToString())
					{
						drDAT[ARTIFICIAL.IgG] = "";
						drDAT[ARTIFICIAL.IgGInterp] = "";
						drDAT[ARTIFICIAL.IgGSave] = false;
						drDAT[ARTIFICIAL.IgGInterpSave] = true;
					}
					else if (orderableTestId == ((int)Common.OrderableTest.DATComp).ToString() ||
							 orderableTestId == ((int)Common.OrderableTest.RepeatDATComp).ToString())
					{
						drDAT[ARTIFICIAL.C3d] = "";
						drDAT[ARTIFICIAL.C3dInterp] = "";
						drDAT[ARTIFICIAL.C3dSave] = false;
						drDAT[ARTIFICIAL.C3dInterpSave] = true;
					}

					drDAT[ARTIFICIAL.CC] = "";
					drDAT[ARTIFICIAL.CCSave] = false;

					//setting up positive control row for Poly DAT
					if ((bool)drControl[TABLE.RackLot.ControlCellId] ==  true &&
						(orderableTestId == ((int)Common.OrderableTest.DAT).ToString() ||
						 orderableTestId == ((int)Common.OrderableTest.RepeatDAT).ToString() ||
						 orderableTestId == ((int)Common.OrderableTest.TAS).ToString() ||
						 orderableTestId == ((int)Common.OrderableTest.ABS).ToString() ||
						 orderableTestId == ((int)Common.OrderableTest.RepeatABS).ToString()))
					{
						DataRow[] drAHGPosResults = dtQCResults.Select("ReagentTypeId = " + (int)Common.DATTestControls.PSDAT + " AND ControlCellId = 1 AND (RecordStatusCode = 'A' OR RecordStatusCode IS NULL)");
						foreach(DataRow drAHGPosResult in drAHGPosResults)
						{
							if (drAHGPosResult[TABLE.RackTest.RackTestResultTypeCode].ToString().Trim() == ARTIFICIAL.AHG)
							{
								if (drAHGPosResult.IsNull(TABLE.RackTest.RackTestResult) == false)
								{
									drDAT[ARTIFICIAL.AHG] = drAHGPosResult[TABLE.RackTest.RackTestResult].ToString().Trim();
									drDAT[ARTIFICIAL.AHGSave] = false;
								}
								else
								{
									drDAT[ARTIFICIAL.AHG] = "";
									drDAT[ARTIFICIAL.AHGSave] = true;
								}
								drDAT[ARTIFICIAL.AHGGuid] = drAHGPosResult[TABLE.RackTest.RackTestGuid];
								drDAT[ARTIFICIAL.AHGRowVersion] = drAHGPosResult[ARTIFICIAL.RackTestRowVersion];
							}
							else if (drAHGPosResult[TABLE.RackTest.RackTestResultTypeCode].ToString().Trim() == ARTIFICIAL.CC)
							{
								if (drAHGPosResult.IsNull(TABLE.RackTest.RackTestResult) == false)
								{
									drDAT[ARTIFICIAL.CC] = drAHGPosResult[TABLE.RackTest.RackTestResult].ToString().Trim();
									drDAT[ARTIFICIAL.CCSave] = false;
								}
								else
								{
									drDAT[ARTIFICIAL.CC] = "";
									drDAT[ARTIFICIAL.CCSave] = true;
								}
								drDAT[ARTIFICIAL.CCGuid] = drAHGPosResult[TABLE.RackTest.RackTestGuid];
								drDAT[ARTIFICIAL.CCRowVersion] = drAHGPosResult[ARTIFICIAL.RackTestRowVersion];
							}
							
							if(drAHGPosResult.IsNull(TABLE.RackLot.SatisfactoryResultIndicator) == false)
							{
								if ((bool)drAHGPosResult[TABLE.RackLot.SatisfactoryResultIndicator] == true)
								{
									drDAT[ARTIFICIAL.AHGInterp] = "P";
									drDAT[ARTIFICIAL.AHGInterpSave] = false;
								}
								else
								{
									drDAT[ARTIFICIAL.AHGInterp] = "N";
									drDAT[ARTIFICIAL.AHGInterpSave] = false;
								}
							}

							if (drAHGPosResult.IsNull(TABLE.RackLot.Comments))
								drDAT[ARTIFICIAL.AHGComment] = "";
							else
								drDAT[ARTIFICIAL.AHGComment] = drAHGPosResult[TABLE.RackLot.Comments];

						}

						drDAT[ARTIFICIAL.TestType] = "POS";
					}
					else if ((bool)drControl[TABLE.RackLot.ControlCellId] ==  false &&
							 (orderableTestId == ((int)Common.OrderableTest.DAT).ToString() ||
							  orderableTestId == ((int)Common.OrderableTest.RepeatDAT).ToString() ||
							  orderableTestId == ((int)Common.OrderableTest.TAS).ToString() ||
							  orderableTestId == ((int)Common.OrderableTest.ABS).ToString() ||
							  orderableTestId == ((int)Common.OrderableTest.RepeatABS).ToString()))
					{
						//negative control row for Poly DAT
						DataRow[] drAHGNegResults = dtQCResults.Select("ReagentTypeId = " + (int)Common.DATTestControls.PSDAT + " AND ControlCellId = 0 AND (RecordStatusCode = 'A' OR RecordStatusCode IS NULL)");
						foreach(DataRow drAHGNegResult in drAHGNegResults)
						{
							if (drAHGNegResult[TABLE.RackTest.RackTestResultTypeCode].ToString().Trim() == ARTIFICIAL.AHG)
							{
								if (drAHGNegResult.IsNull(TABLE.RackTest.RackTestResult) == false)
								{
									drDAT[ARTIFICIAL.AHG] = drAHGNegResult[TABLE.RackTest.RackTestResult].ToString().Trim();
									drDAT[ARTIFICIAL.AHGSave] = false;
								}
								else
								{
									drDAT[ARTIFICIAL.AHG] = "";
									drDAT[ARTIFICIAL.AHGSave] = true;
								}
								drDAT[ARTIFICIAL.AHGGuid] = drAHGNegResult[TABLE.RackTest.RackTestGuid];
								drDAT[ARTIFICIAL.AHGRowVersion] = drAHGNegResult[ARTIFICIAL.RackTestRowVersion];
							}
							else if (drAHGNegResult[TABLE.RackTest.RackTestResultTypeCode].ToString().Trim() == ARTIFICIAL.CC)
							{
								if (drAHGNegResult.IsNull(TABLE.RackTest.RackTestResult) == false)
								{
									drDAT[ARTIFICIAL.CC] = drAHGNegResult[TABLE.RackTest.RackTestResult].ToString().Trim();
									drDAT[ARTIFICIAL.CCSave] = false;
								}
								else
								{
									drDAT[ARTIFICIAL.CC] = "";
									drDAT[ARTIFICIAL.CCSave] = true;
								}
								drDAT[ARTIFICIAL.CCGuid] = drAHGNegResult[TABLE.RackTest.RackTestGuid];
								drDAT[ARTIFICIAL.CCRowVersion] = drAHGNegResult[ARTIFICIAL.RackTestRowVersion];
							}

							if(drAHGNegResult.IsNull(TABLE.RackLot.SatisfactoryResultIndicator) == false)
							{
								if ((bool)drAHGNegResult[TABLE.RackLot.SatisfactoryResultIndicator] == true)
								{
									drDAT[ARTIFICIAL.AHGInterp] = "N";
									drDAT[ARTIFICIAL.AHGInterpSave] = false;
								}
								else
								{
									drDAT[ARTIFICIAL.AHGInterp] = "P";
									drDAT[ARTIFICIAL.AHGInterpSave] = false;
								}
							}

							if (drAHGNegResult.IsNull(TABLE.RackLot.Comments))
								drDAT[ARTIFICIAL.AHGComment] = "";
							else
								drDAT[ARTIFICIAL.AHGComment] = drAHGNegResult[TABLE.RackLot.Comments];
						}

						drDAT[ARTIFICIAL.TestType] = "NEG";
					}
					else if ((bool)drControl[TABLE.RackLot.ControlCellId] ==  true &&
							 (orderableTestId == ((int)Common.OrderableTest.DATIgG).ToString() ||
							  orderableTestId == ((int)Common.OrderableTest.RepeatDATIgG).ToString()))
					{
						//positive control for IgG DAT
						DataRow[] drIgGPosResults = dtQCResults.Select("ReagentTypeId = " + (int)Common.DATTestControls.IgGDAT + " AND ControlCellId = 1 AND (RecordStatusCode = 'A' OR RecordStatusCode IS NULL)");
						foreach(DataRow drIgGPosResult in drIgGPosResults)
						{
							if (drIgGPosResult[TABLE.RackTest.RackTestResultTypeCode].ToString().Trim() == ARTIFICIAL.AHG)
							{
								if (drIgGPosResult.IsNull(TABLE.RackTest.RackTestResult) == false)
								{
									drDAT[ARTIFICIAL.IgG] = drIgGPosResult[TABLE.RackTest.RackTestResult].ToString().Trim();
									drDAT[ARTIFICIAL.IgGSave] = false;
								}
								else
								{
									drDAT[ARTIFICIAL.IgG] = "";
									drDAT[ARTIFICIAL.IgGSave] = true;
								}
								drDAT[ARTIFICIAL.IgGGuid] = drIgGPosResult[TABLE.RackTest.RackTestGuid];
								drDAT[ARTIFICIAL.IgGRowVersion] = drIgGPosResult[ARTIFICIAL.RackTestRowVersion];
							}
							else if (drIgGPosResult[TABLE.RackTest.RackTestResultTypeCode].ToString().Trim() == ARTIFICIAL.CC)
							{
								if (drIgGPosResult.IsNull(TABLE.RackTest.RackTestResult) == false)
								{
									drDAT[ARTIFICIAL.CC] = drIgGPosResult[TABLE.RackTest.RackTestResult].ToString().Trim();
									drDAT[ARTIFICIAL.CCSave] = false;
								}
								else
								{
									drDAT[ARTIFICIAL.CC] = "";
									drDAT[ARTIFICIAL.CCSave] = true;
								}
								drDAT[ARTIFICIAL.CCGuid] = drIgGPosResult[TABLE.RackTest.RackTestGuid];
								drDAT[ARTIFICIAL.CCRowVersion] = drIgGPosResult[ARTIFICIAL.RackTestRowVersion];
							}
							
							if(drIgGPosResult.IsNull(TABLE.RackLot.SatisfactoryResultIndicator) == false)
							{
								if ((bool)drIgGPosResult[TABLE.RackLot.SatisfactoryResultIndicator] == true)
								{
									drDAT[ARTIFICIAL.IgGInterp] = "P";
									drDAT[ARTIFICIAL.IgGInterpSave] = false;
								}
								else
								{
									drDAT[ARTIFICIAL.IgGInterp] = "N";
									drDAT[ARTIFICIAL.IgGInterpSave] = false;
								}
							}
				
							if (drIgGPosResult.IsNull(TABLE.RackLot.Comments))
								drDAT[ARTIFICIAL.IgGComment] = "";
							else
								drDAT[ARTIFICIAL.IgGComment] = drIgGPosResult[TABLE.RackLot.Comments];
						}

						drDAT[ARTIFICIAL.TestType] = "POS";
					}
					else if ((bool)drControl[TABLE.RackLot.ControlCellId] ==  false &&
							 (orderableTestId == ((int)Common.OrderableTest.DATIgG).ToString() ||
							  orderableTestId == ((int)Common.OrderableTest.RepeatDATIgG).ToString()))
					{
						//negative control row for IgG DAT
						DataRow[] drIgGNegResults = dtQCResults.Select("ReagentTypeId = " + (int)Common.DATTestControls.IgGDAT + " AND ControlCellId = 0 AND (RecordStatusCode = 'A' OR RecordStatusCode IS NULL)");
						foreach(DataRow drIgGNegResult in drIgGNegResults)
						{
							if (drIgGNegResult[TABLE.RackTest.RackTestResultTypeCode].ToString().Trim() == ARTIFICIAL.AHG)
							{
								if (drIgGNegResult.IsNull(TABLE.RackTest.RackTestResult) == false)
								{
									drDAT[ARTIFICIAL.IgG] = drIgGNegResult[TABLE.RackTest.RackTestResult].ToString().Trim();
									drDAT[ARTIFICIAL.IgGSave] = false;
								}
								else
								{
									drDAT[ARTIFICIAL.IgG] = "";
									drDAT[ARTIFICIAL.IgGSave] = true;
								}
								drDAT[ARTIFICIAL.IgGGuid] = drIgGNegResult[TABLE.RackTest.RackTestGuid];
								drDAT[ARTIFICIAL.IgGRowVersion] = drIgGNegResult[ARTIFICIAL.RackTestRowVersion];
							}
							else if (drIgGNegResult[TABLE.RackTest.RackTestResultTypeCode].ToString().Trim() == ARTIFICIAL.CC)
							{
								if (drIgGNegResult.IsNull(TABLE.RackTest.RackTestResult) == false)
								{
									drDAT[ARTIFICIAL.CC] = drIgGNegResult[TABLE.RackTest.RackTestResult].ToString().Trim();
									drDAT[ARTIFICIAL.CCSave] = false;
								}
								else
								{
									drDAT[ARTIFICIAL.CC] = "";
									drDAT[ARTIFICIAL.CCSave] = true;
								}
								drDAT[ARTIFICIAL.CCGuid] = drIgGNegResult[TABLE.RackTest.RackTestGuid];
								drDAT[ARTIFICIAL.CCRowVersion] = drIgGNegResult[ARTIFICIAL.RackTestRowVersion];
							}

							if(drIgGNegResult.IsNull(TABLE.RackLot.SatisfactoryResultIndicator) == false)
							{
								if ((bool)drIgGNegResult[TABLE.RackLot.SatisfactoryResultIndicator] == true)
								{
									drDAT[ARTIFICIAL.IgGInterp] = "N";
									drDAT[ARTIFICIAL.IgGInterpSave] = false;
								}
								else
								{
									drDAT[ARTIFICIAL.IgGInterp] = "P";
									drDAT[ARTIFICIAL.IgGInterpSave] = false;
								}
							}

							if (drIgGNegResult.IsNull(TABLE.RackLot.Comments))
								drDAT[ARTIFICIAL.IgGComment] = "";
							else
								drDAT[ARTIFICIAL.IgGComment] = drIgGNegResult[TABLE.RackLot.Comments];
						}

						drDAT[ARTIFICIAL.TestType] = "NEG";
					}
					else if ((bool)drControl[TABLE.RackLot.ControlCellId] ==  true &&
							 (orderableTestId == ((int)Common.OrderableTest.DATComp).ToString() ||
							  orderableTestId == ((int)Common.OrderableTest.RepeatDATComp).ToString()))
					{
						//positive control for C3d DAT
						DataRow[] drC3dPosResults = dtQCResults.Select("ReagentTypeId = " + (int)Common.DATTestControls.CompDAT + " AND ControlCellId = 1 AND (RecordStatusCode = 'A' OR RecordStatusCode IS NULL)");
						foreach(DataRow drC3dPosResult in drC3dPosResults)
						{
							if (drC3dPosResult[TABLE.RackTest.RackTestResultTypeCode].ToString().Trim() == ARTIFICIAL.AHG)
							{
								if (drC3dPosResult.IsNull(TABLE.RackTest.RackTestResult) == false)
								{
									drDAT[ARTIFICIAL.C3d] = drC3dPosResult[TABLE.RackTest.RackTestResult].ToString().Trim();
									drDAT[ARTIFICIAL.C3dSave] = false;
								}
								else
								{
									drDAT[ARTIFICIAL.C3d] = "";
									drDAT[ARTIFICIAL.C3dSave] = true;
								}
								drDAT[ARTIFICIAL.C3dGuid] = drC3dPosResult[TABLE.RackTest.RackTestGuid];
								drDAT[ARTIFICIAL.C3dRowVersion] = drC3dPosResult[ARTIFICIAL.RackTestRowVersion];
							}
							else if (drC3dPosResult[TABLE.RackTest.RackTestResultTypeCode].ToString().Trim() == ARTIFICIAL.CC)
							{
								if (drC3dPosResult.IsNull(TABLE.RackTest.RackTestResult) == false)
								{
									drDAT[ARTIFICIAL.CC] = drC3dPosResult[TABLE.RackTest.RackTestResult].ToString().Trim();
									drDAT[ARTIFICIAL.CCSave] = false;
								}
								else
								{
									drDAT[ARTIFICIAL.CC] = "";
									drDAT[ARTIFICIAL.CCSave] = true;
								}
								drDAT[ARTIFICIAL.CCGuid] = drC3dPosResult[TABLE.RackTest.RackTestGuid];
								drDAT[ARTIFICIAL.CCRowVersion] = drC3dPosResult[ARTIFICIAL.RackTestRowVersion];
							}
							
							if(drC3dPosResult.IsNull(TABLE.RackLot.SatisfactoryResultIndicator) == false)
							{
								if ((bool)drC3dPosResult[TABLE.RackLot.SatisfactoryResultIndicator] == true)
								{
									drDAT[ARTIFICIAL.C3dInterp] = "P";
									drDAT[ARTIFICIAL.C3dInterpSave] = false;
								}
								else
								{
									drDAT[ARTIFICIAL.C3dInterp] = "N";
									drDAT[ARTIFICIAL.C3dInterpSave] = false;
								}
							}

							if (drC3dPosResult.IsNull(TABLE.RackLot.Comments))
								drDAT[ARTIFICIAL.C3dComment] = "";
							else
								drDAT[ARTIFICIAL.C3dComment] = drC3dPosResult[TABLE.RackLot.Comments];
						}

						drDAT[ARTIFICIAL.TestType] = "POS";
					}
					else if ((bool)drControl[TABLE.RackLot.ControlCellId] ==  false &&
							 (orderableTestId == ((int)Common.OrderableTest.DATComp).ToString() ||
							  orderableTestId == ((int)Common.OrderableTest.RepeatDATComp).ToString()))
					{
						//negative control row for IgG DAT
						DataRow[] drC3dNegResults = dtQCResults.Select("ReagentTypeId = " + (int)Common.DATTestControls.CompDAT + " AND ControlCellId = 0 AND (RecordStatusCode = 'A' OR RecordStatusCode IS NULL)");
						foreach(DataRow drC3dNegResult in drC3dNegResults)
						{
							if (drC3dNegResult[TABLE.RackTest.RackTestResultTypeCode].ToString().Trim() == ARTIFICIAL.AHG)
							{
								if (drC3dNegResult.IsNull(TABLE.RackTest.RackTestResult) == false)
								{
									drDAT[ARTIFICIAL.C3d] = drC3dNegResult[TABLE.RackTest.RackTestResult].ToString().Trim();
									drDAT[ARTIFICIAL.C3dSave] = false;
								}
								else
								{
									drDAT[ARTIFICIAL.C3d] = "";
									drDAT[ARTIFICIAL.C3dSave] = true;
								}
								drDAT[ARTIFICIAL.C3dGuid] = drC3dNegResult[TABLE.RackTest.RackTestGuid];
								drDAT[ARTIFICIAL.C3dRowVersion] = drC3dNegResult[ARTIFICIAL.RackTestRowVersion];
							}
							else if (drC3dNegResult[TABLE.RackTest.RackTestResultTypeCode].ToString().Trim() == ARTIFICIAL.CC)
							{
								if (drC3dNegResult.IsNull(TABLE.RackTest.RackTestResult) == false)
								{
									drDAT[ARTIFICIAL.CC] = drC3dNegResult[TABLE.RackTest.RackTestResult].ToString().Trim();
									drDAT[ARTIFICIAL.CCSave] = false;
								}
								else
								{
									drDAT[ARTIFICIAL.CC] = "";
									drDAT[ARTIFICIAL.CCSave] = true;
								}
								drDAT[ARTIFICIAL.CCGuid] = drC3dNegResult[TABLE.RackTest.RackTestGuid];
								drDAT[ARTIFICIAL.CCRowVersion] = drC3dNegResult[ARTIFICIAL.RackTestRowVersion];
							}

							if(drC3dNegResult.IsNull(TABLE.RackLot.SatisfactoryResultIndicator) == false)
							{
								if ((bool)drC3dNegResult[TABLE.RackLot.SatisfactoryResultIndicator] == true)
								{
									drDAT[ARTIFICIAL.C3dInterp] = "N";
									drDAT[ARTIFICIAL.C3dInterpSave] = false;
								}
								else
								{
									drDAT[ARTIFICIAL.C3dInterp] = "P";
									drDAT[ARTIFICIAL.C3dInterpSave] = false;
								}
							}

							if (drC3dNegResult.IsNull(TABLE.RackLot.Comments))
								drDAT[ARTIFICIAL.C3dComment] = "";
							else
								drDAT[ARTIFICIAL.C3dComment] = drC3dNegResult[TABLE.RackLot.Comments];
						}

						drDAT[ARTIFICIAL.TestType] = "NEG";
					}

					if (drDAT[ARTIFICIAL.TestType].ToString() == "NEG")
						drNeg = drDAT;
					else if (drDAT[ARTIFICIAL.TestType].ToString() == "POS")
						drPos = drDAT;
				}
                //CR 3554
                if (drControls == null)
                    throw new ApplicationException("drControls is null");

				if (drControls.Length > 0)
				{
					object[] objPatient = dtDAT.Rows[0].ItemArray;
					DataRow drPatient = dtDAT.NewRow();
					drPatient.ItemArray = objPatient;

					dtDAT.Rows.RemoveAt(0);
					dtDAT.Rows.Add(drPos);
					dtDAT.Rows.Add(drNeg);
					dtDAT.Rows.Add(drPatient);
				}

				foreach(DataRow dr in dtDAT.Rows)
				{
					dr[TABLE.OrderableTest.OrderableTestId] = orderableTestId;
				}
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/3/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2983"> 
		///		<ExpectedInput>DataTable that is being filled with partially completed test results and OrderedTest object that has test results associated with it</ExpectedInput>
		///		<ExpectedOutput>DataTable contatining test results for OrderedTest</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2984"> 
		///		<ExpectedInput>Invalid DataTable, invalid OrderedTest object</ExpectedInput>
		///		<ExpectedOutput>NullReferenceException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Load previously entered test results into AGT row that drives the datagrid
		/// </summary>
		/// <param name="dtAGT"></param>
		/// <param name="test"></param>
		public static void BuildAGTFromSpecimenTest(DataTable dtAGT, BOL.OrderedTest test)
		{
			string BloodTestType = "";
			string BloodTestTypePrefix = "";
			bool WeakDTyping = false;
			DataRow drAGT=null, drPos=null, drNeg=null;
			int RowNumber = 0;

			DataTable dtBloodTestTypes = BOL.BloodTestType.GetBloodTestTypes(Convert.ToString(test.OrderableTestId));
			DataTable dtSpecimenTests = DAL.OrderedTest.GetTestResultsForTask(test.OrderedTestGuid);

			if (test.OrderableTestId == (int)Common.OrderableTest.AGwD ||
				test.OrderableTestId == (int)Common.OrderableTest.RepeatAGwD)
			{
				WeakDTyping = true;
			}

			foreach(DataRow drSpecimenTest in dtSpecimenTests.Rows)
			{
				BloodTestType = dtBloodTestTypes.Select("BloodTestTypeId = '" + drSpecimenTest[TABLE.SpecimenTest.BloodTestTypeId].ToString() + "'")[0][TABLE.BloodTestType.BloodTestName].ToString();

				//add aditional row for D Control if the results are present (only for Weak D typing)
				if (BloodTestType.IndexOf("D Control") != -1 &&
					WeakDTyping == true &&
					dtAGT.Rows.Count == 1)
				{
					drAGT = dtAGT.NewRow();
					drAGT[TABLE.PatientSpecimen.PatientGuid] = dtAGT.Rows[0][TABLE.PatientSpecimen.PatientGuid];
					drAGT[TABLE.SpecimenTest.PatientSpecimenGuid] = dtAGT.Rows[0][TABLE.SpecimenTest.PatientSpecimenGuid];
					drAGT[TABLE.SpecimenTest.OrderedTestGuid] = dtAGT.Rows[0][TABLE.SpecimenTest.OrderedTestGuid];
					drAGT[TABLE.BloodTestType.OrderableTestId] = dtAGT.Rows[0][TABLE.BloodTestType.OrderableTestId];
					drAGT[ARTIFICIAL.Indicator] = "";
					drAGT[ARTIFICIAL.TestType] = "Anti-D Control";
					dtAGT.Rows.Add(drAGT);
				}

				//setting the prefix that will help to find appropriate blood test types and associate them
				//with the proper phases of reaction
				if (WeakDTyping == true)
				{
					if (BloodTestType.IndexOf("D Control") != -1)
					{
						BloodTestTypePrefix = "D Control ";
						RowNumber = 1;
					}
					else if (BloodTestType.IndexOf("Anti wD") != -1)
					{
						BloodTestTypePrefix = "Anti wD ";
						RowNumber = 0;
					}
				}
				else
				{
					BloodTestTypePrefix = "";
				}

				if (BloodTestType.IndexOf(BloodTestTypePrefix + ARTIFICIAL.IS) != -1)
				{
					if (drSpecimenTest.IsNull(TABLE.SpecimenTest.TestResultId) == false)
					{
						dtAGT.Rows[RowNumber][ARTIFICIAL.IS] = drSpecimenTest[TABLE.SpecimenTest.TestResultId].ToString().Trim();
						dtAGT.Rows[RowNumber][ARTIFICIAL.ISSave] = false;
					}
					else
					{
						dtAGT.Rows[RowNumber][ARTIFICIAL.IS] = "";
						dtAGT.Rows[RowNumber][ARTIFICIAL.ISSave] = true;
					}
					dtAGT.Rows[RowNumber][ARTIFICIAL.Comment] = drSpecimenTest[TABLE.SpecimenTest.TestComments];
					dtAGT.Rows[RowNumber][ARTIFICIAL.ISGuid] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];
					dtAGT.Rows[RowNumber][ARTIFICIAL.ISRowVersion] = drSpecimenTest[TABLE.SpecimenTest.RowVersion];
				}
				if (BloodTestType.IndexOf(BloodTestTypePrefix + ARTIFICIAL.RT) != -1)
				{
					if (drSpecimenTest.IsNull(TABLE.SpecimenTest.TestResultId) == false)
					{
						dtAGT.Rows[RowNumber][ARTIFICIAL.RT] = drSpecimenTest[TABLE.SpecimenTest.TestResultId].ToString().Trim();
						dtAGT.Rows[RowNumber][ARTIFICIAL.RTSave] = false;
					}
					else
					{
						dtAGT.Rows[RowNumber][ARTIFICIAL.RT] = "";
						dtAGT.Rows[RowNumber][ARTIFICIAL.RTSave] = true;
					}
					dtAGT.Rows[RowNumber][ARTIFICIAL.Comment] = drSpecimenTest[TABLE.SpecimenTest.TestComments];
					dtAGT.Rows[RowNumber][ARTIFICIAL.RTGuid] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];
					dtAGT.Rows[RowNumber][ARTIFICIAL.RTRowVersion] = drSpecimenTest[TABLE.SpecimenTest.RowVersion];
				}
				if (BloodTestType.IndexOf(BloodTestTypePrefix + ARTIFICIAL.C37) != -1)
				{
					if (drSpecimenTest.IsNull(TABLE.SpecimenTest.TestResultId) == false)
					{
						dtAGT.Rows[RowNumber][ARTIFICIAL.C37] = drSpecimenTest[TABLE.SpecimenTest.TestResultId].ToString().Trim();
						dtAGT.Rows[RowNumber][ARTIFICIAL.C37Save] = false;
					}
					else
					{
						dtAGT.Rows[RowNumber][ARTIFICIAL.C37] = "";
						dtAGT.Rows[RowNumber][ARTIFICIAL.C37Save] = true;
					}
					dtAGT.Rows[RowNumber][ARTIFICIAL.Comment] = drSpecimenTest[TABLE.SpecimenTest.TestComments];
					dtAGT.Rows[RowNumber][ARTIFICIAL.C37Guid] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];
					dtAGT.Rows[RowNumber][ARTIFICIAL.C37RowVersion] = drSpecimenTest[TABLE.SpecimenTest.RowVersion];
				}
				if (BloodTestType.IndexOf(BloodTestTypePrefix + ARTIFICIAL.AHG) != -1)
				{
					if (drSpecimenTest.IsNull(TABLE.SpecimenTest.TestResultId) == false)
					{
						dtAGT.Rows[RowNumber][ARTIFICIAL.AHG] = drSpecimenTest[TABLE.SpecimenTest.TestResultId].ToString().Trim();
						dtAGT.Rows[RowNumber][ARTIFICIAL.AHGSave] = false;
					}
					else
					{
						dtAGT.Rows[RowNumber][ARTIFICIAL.AHG] = "";
						dtAGT.Rows[RowNumber][ARTIFICIAL.AHGSave] = true;
					}
					dtAGT.Rows[RowNumber][ARTIFICIAL.Comment] = drSpecimenTest[TABLE.SpecimenTest.TestComments];
					dtAGT.Rows[RowNumber][ARTIFICIAL.AHGGuid] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];
					dtAGT.Rows[RowNumber][ARTIFICIAL.AHGRowVersion] = drSpecimenTest[TABLE.SpecimenTest.RowVersion];
				}
				else if (BloodTestType.IndexOf(BloodTestTypePrefix + ARTIFICIAL.CC) != -1)
				{
					if (drSpecimenTest.IsNull(TABLE.SpecimenTest.TestResultId) == false)
					{
						dtAGT.Rows[RowNumber][ARTIFICIAL.CC] = drSpecimenTest[TABLE.SpecimenTest.TestResultId].ToString().Trim();
						dtAGT.Rows[RowNumber][ARTIFICIAL.CCSave] = false;
					}
					else
					{
						dtAGT.Rows[RowNumber][ARTIFICIAL.CC] = "";
						dtAGT.Rows[RowNumber][ARTIFICIAL.CCSave] = true;
					}
					dtAGT.Rows[RowNumber][ARTIFICIAL.Comment] = drSpecimenTest[TABLE.SpecimenTest.TestComments];
					dtAGT.Rows[RowNumber][ARTIFICIAL.CCGuid] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];
					dtAGT.Rows[RowNumber][ARTIFICIAL.CCRowVersion] = drSpecimenTest[TABLE.SpecimenTest.RowVersion];
				}
				else if (BloodTestType.IndexOf(ARTIFICIAL.Interp) != -1)
				{
					if (drSpecimenTest.IsNull(TABLE.SpecimenTest.TestResultId) == false)
					{
						dtAGT.Rows[RowNumber][ARTIFICIAL.Interp] = drSpecimenTest[TABLE.SpecimenTest.TestResultId].ToString().Trim();
						dtAGT.Rows[RowNumber][ARTIFICIAL.InterpSave] = false;
					}
					else
					{
						dtAGT.Rows[RowNumber][ARTIFICIAL.Interp] = "";
						dtAGT.Rows[RowNumber][ARTIFICIAL.InterpSave] = true;
					}
					dtAGT.Rows[RowNumber][ARTIFICIAL.Comment] = drSpecimenTest[TABLE.SpecimenTest.TestComments];
					dtAGT.Rows[RowNumber][ARTIFICIAL.InterpGuid] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];
					dtAGT.Rows[RowNumber][ARTIFICIAL.InterpRowVersion] = drSpecimenTest[TABLE.SpecimenTest.RowVersion];
				}
				
				if (drSpecimenTest.IsNull(TABLE.SpecimenTest.CorrectedResultIndicator))
				{
					dtAGT.Rows[RowNumber][TABLE.SpecimenTest.CorrectedResultIndicator] = false;
				}
				else
				{
					dtAGT.Rows[RowNumber][TABLE.SpecimenTest.CorrectedResultIndicator] = (bool)drSpecimenTest[TABLE.SpecimenTest.CorrectedResultIndicator];
				}

				if (drSpecimenTest.IsNull(TABLE.Rack.RackGuid) == false)
					dtAGT.Rows[RowNumber][TABLE.Rack.RackGuid] = (Guid)drSpecimenTest[TABLE.Rack.RackGuid];
			}

			DataTable dtQCResults = OrderedTest.GetQCResultsForOrderedTest(test.OrderedTestGuid);

			if (dtQCResults.Rows.Count > 0)
			{
				DataRow drQC = dtQCResults.Select("ReagentTypeId = " + test.GetReagentTypeForOrderableTest().ReagentTypeId + " AND (RecordStatusCode = 'A' OR RecordStatusCode IS NULL)")[0];
				dtAGT.Rows[0][TABLE.Reagent.LotNumber] = drQC[TABLE.Reagent.LotNumber];
				dtAGT.Rows[0]["LotNumberSave"] = false;
				dtAGT.Rows[0][TABLE.RackLot.ReagentGuid] = drQC[TABLE.RackLot.ReagentGuid];
				dtAGT.Rows[0][TABLE.ReagentType.ReagentTypeId] = drQC[TABLE.ReagentType.ReagentTypeId];
				dtAGT.Rows[0]["Manufacturer"] = drQC[TABLE.Reagent.ReagentManufacturerName];
				dtAGT.Rows[0]["ExpirationDate"] = drQC[TABLE.Reagent.LotExpirationDate];

				if (WeakDTyping == false)
				{
					if (drQC.IsNull(TABLE.RackLot.LotVialNumber) == false)
					{
						dtAGT.Rows[0][ARTIFICIAL.VialId] = drQC[TABLE.RackLot.LotVialNumber];
						if (drQC[TABLE.RackLot.LotVialNumber].ToString() != "")
							dtAGT.Rows[0][ARTIFICIAL.VialIdSave] = false;
					}
				}

				if (WeakDTyping == true && dtAGT.Rows.Count > 1)
				{
					drQC = dtQCResults.Select("ReagentTypeId = " + (int)Common.WeakDTestReagents.AntiDControl)[0];
					dtAGT.Rows[1][TABLE.Reagent.LotNumber] = drQC[TABLE.Reagent.LotNumber];
					dtAGT.Rows[1]["LotNumberSave"] = false;
					dtAGT.Rows[1][TABLE.RackLot.ReagentGuid] = drQC[TABLE.RackLot.ReagentGuid];
					dtAGT.Rows[1][TABLE.ReagentType.ReagentTypeId] = drQC[TABLE.ReagentType.ReagentTypeId];
					dtAGT.Rows[1]["Manufacturer"] = drQC[TABLE.Reagent.ReagentManufacturerName];
					dtAGT.Rows[1]["ExpirationDate"] = drQC[TABLE.Reagent.LotExpirationDate];
				}

				DataRow[] drControls = null;

				drControls = dtQCResults.Select("ReagentTypeId <> " + test.GetReagentTypeForOrderableTest().ReagentTypeId + " AND (RecordStatusCode = 'A' OR RecordStatusCode IS NULL)", "ReagentTypeId DESC");

				foreach(DataRow drControl in drControls)
				{
					drAGT = dtAGT.NewRow();
					drAGT[TABLE.PatientSpecimen.PatientGuid] = dtAGT.Rows[0][TABLE.PatientSpecimen.PatientGuid];
					drAGT[TABLE.SpecimenTest.PatientSpecimenGuid] = dtAGT.Rows[0][TABLE.SpecimenTest.PatientSpecimenGuid];
					drAGT[TABLE.SpecimenTest.OrderedTestGuid] = dtAGT.Rows[0][TABLE.SpecimenTest.OrderedTestGuid];
					drAGT[ARTIFICIAL.OrderedTestRowVersion] = dtAGT.Rows[0][ARTIFICIAL.OrderedTestRowVersion];
					drAGT[TABLE.BloodTestType.OrderableTestId] = dtAGT.Rows[0][TABLE.BloodTestType.OrderableTestId];
					drAGT[ARTIFICIAL.Indicator] = "";
					drAGT[TABLE.Reagent.LotNumber] = drControl[TABLE.Reagent.LotNumber];
					drAGT["Manufacturer"] = drControl[TABLE.Reagent.ReagentManufacturerName];
					drAGT["ExpirationDate"] = drControl[TABLE.Reagent.LotExpirationDate];
					drAGT["LotNumberSave"] = false;
					drAGT[TABLE.ReagentType.ReagentTypeId] = drControl[TABLE.ReagentType.ReagentTypeId];
					drAGT[TABLE.RackLot.ReagentGuid] = drControl[TABLE.RackLot.ReagentGuid];
					drAGT[ARTIFICIAL.PartiallyCompleted] = true;
					drAGT[TABLE.Rack.RackGuid] = dtAGT.Rows[0][TABLE.Rack.RackGuid];
					if (drControl.IsNull(TABLE.RackLot.LotVialNumber) == false)
					{
						drAGT[ARTIFICIAL.VialId] = drControl[TABLE.RackLot.LotVialNumber].ToString().Trim();
						if (drControl[TABLE.RackLot.LotVialNumber].ToString().Trim() != "")
							drAGT[ARTIFICIAL.VialIdSave] = false;
						else
							drAGT[ARTIFICIAL.VialIdSave] = true;
					}
					else
					{
						drAGT[ARTIFICIAL.VialId] = "";
						drAGT[ARTIFICIAL.VialIdSave] = true;
					}

					drAGT[ARTIFICIAL.IS] = "";
					drAGT[ARTIFICIAL.RT] = "";
					drAGT[ARTIFICIAL.C37] = "";
					drAGT[ARTIFICIAL.AHG] = "";
					drAGT[ARTIFICIAL.Interp] = "";
					drAGT[ARTIFICIAL.ISSave] = false;
					drAGT[ARTIFICIAL.RTSave] = false;
					drAGT[ARTIFICIAL.C37Save] = false;
					drAGT[ARTIFICIAL.AHGSave] = false;
					drAGT[ARTIFICIAL.InterpSave] = true;
					drAGT[ARTIFICIAL.Comment] = "";

					drAGT[ARTIFICIAL.CC] = "";
					drAGT[ARTIFICIAL.CCSave] = false;

					//setting up positive control row
					if ((bool)drControl[TABLE.RackLot.ControlCellId] ==  true)
					{
						DataRow[] drPosResults = dtQCResults.Select("ReagentTypeId = " + test.GetReagentTypeForOrderableTest().ReagentTypeId + " AND ControlCellId = 1 AND (RecordStatusCode = 'A' OR RecordStatusCode IS NULL)");
						foreach(DataRow drPosResult in drPosResults)
						{
							if (drPosResult[TABLE.RackTest.RackTestResultTypeCode].ToString().Trim() == ARTIFICIAL.IS)
							{
								if (drPosResult.IsNull(TABLE.RackTest.RackTestResult) == false)
								{
									drAGT[ARTIFICIAL.IS] = drPosResult[TABLE.RackTest.RackTestResult].ToString().Trim();
									drAGT[ARTIFICIAL.ISSave] = false;
								}
								else
								{
									drAGT[ARTIFICIAL.IS] = "";
									drAGT[ARTIFICIAL.ISSave] = true;
								}
								drAGT[ARTIFICIAL.ISGuid] = drPosResult[TABLE.RackTest.RackTestGuid];
								drAGT[ARTIFICIAL.ISRowVersion] = drPosResult[ARTIFICIAL.RackTestRowVersion];
							}
							else if (drPosResult[TABLE.RackTest.RackTestResultTypeCode].ToString().Trim() == ARTIFICIAL.RT)
							{
								if (drPosResult.IsNull(TABLE.RackTest.RackTestResult) == false)
								{
									drAGT[ARTIFICIAL.RT] = drPosResult[TABLE.RackTest.RackTestResult].ToString().Trim();
									drAGT[ARTIFICIAL.RTSave] = false;
								}
								else
								{
									drAGT[ARTIFICIAL.RT] = "";
									drAGT[ARTIFICIAL.RTSave] = true;
								}
								drAGT[ARTIFICIAL.RTGuid] = drPosResult[TABLE.RackTest.RackTestGuid];
								drAGT[ARTIFICIAL.RTRowVersion] = drPosResult[ARTIFICIAL.RackTestRowVersion];
							}
							else if (drPosResult[TABLE.RackTest.RackTestResultTypeCode].ToString().Trim() == ARTIFICIAL.C37)
							{
								if (drPosResult.IsNull(TABLE.RackTest.RackTestResult) == false)
								{
									drAGT[ARTIFICIAL.C37] = drPosResult[TABLE.RackTest.RackTestResult].ToString().Trim();
									drAGT[ARTIFICIAL.C37Save] = false;
								}
								else
								{
									drAGT[ARTIFICIAL.C37] = "";
									drAGT[ARTIFICIAL.C37Save] = true;
								}
								drAGT[ARTIFICIAL.C37Guid] = drPosResult[TABLE.RackTest.RackTestGuid];
								drAGT[ARTIFICIAL.C37RowVersion] = drPosResult[ARTIFICIAL.RackTestRowVersion];
							}
							else if (drPosResult[TABLE.RackTest.RackTestResultTypeCode].ToString().Trim() == ARTIFICIAL.AHG)
							{
								if (drPosResult.IsNull(TABLE.RackTest.RackTestResult) == false)
								{
									drAGT[ARTIFICIAL.AHG] = drPosResult[TABLE.RackTest.RackTestResult].ToString().Trim();
									drAGT[ARTIFICIAL.AHGSave] = false;
								}
								else
								{
									drAGT[ARTIFICIAL.AHG] = "";
									drAGT[ARTIFICIAL.AHGSave] = true;
								}
								drAGT[ARTIFICIAL.AHGGuid] = drPosResult[TABLE.RackTest.RackTestGuid];
								drAGT[ARTIFICIAL.AHGRowVersion] = drPosResult[ARTIFICIAL.RackTestRowVersion];
							}
							else if (drPosResult[TABLE.RackTest.RackTestResultTypeCode].ToString().Trim() == ARTIFICIAL.CC)
							{
								if (drPosResult.IsNull(TABLE.RackTest.RackTestResult) == false)
								{
									drAGT[ARTIFICIAL.CC] = drPosResult[TABLE.RackTest.RackTestResult].ToString().Trim();
									drAGT[ARTIFICIAL.CCSave] = false;
								}
								else
								{
									drAGT[ARTIFICIAL.CC] = "";
									drAGT[ARTIFICIAL.CCSave] = true;
								}
								drAGT[ARTIFICIAL.CCGuid] = drPosResult[TABLE.RackTest.RackTestGuid];
								drAGT[ARTIFICIAL.CCRowVersion] = drPosResult[ARTIFICIAL.RackTestRowVersion];
							}
							
							if(drPosResult.IsNull(TABLE.RackLot.SatisfactoryResultIndicator) == false)
							{
								if ((bool)drPosResult[TABLE.RackLot.SatisfactoryResultIndicator] == true)
								{
									drAGT[ARTIFICIAL.Interp] = "P";
									drAGT[ARTIFICIAL.InterpSave] = false;
								}
								else
								{
									drAGT[ARTIFICIAL.Interp] = "N";
									drAGT[ARTIFICIAL.InterpSave] = false;
								}
							}

							if (drPosResult.IsNull(TABLE.RackLot.Comments) == true)
							{
								drAGT[ARTIFICIAL.Comment] = "";
							}
							else
							{
								drAGT[ARTIFICIAL.Comment] = drPosResult[TABLE.RackLot.Comments];
							}
						}

						drAGT[ARTIFICIAL.TestType] = "POS";
					}
					else if ((bool)drControl[TABLE.RackLot.ControlCellId] == false)
					{
						//negative control
						DataRow[] drNegResults = dtQCResults.Select("ReagentTypeId = " + test.GetReagentTypeForOrderableTest().ReagentTypeId + " AND ControlCellId = 0 AND (RecordStatusCode = 'A' OR RecordStatusCode IS NULL)");
						foreach(DataRow drNegResult in drNegResults)
						{
							if (drNegResult[TABLE.RackTest.RackTestResultTypeCode].ToString().Trim() == ARTIFICIAL.IS)
							{
								if (drNegResult.IsNull(TABLE.RackTest.RackTestResult) == false)
								{
									drAGT[ARTIFICIAL.IS] = drNegResult[TABLE.RackTest.RackTestResult].ToString().Trim();
									drAGT[ARTIFICIAL.ISSave] = false;
								}
								else
								{
									drAGT[ARTIFICIAL.IS] = "";
									drAGT[ARTIFICIAL.ISSave] = true;
								}
								drAGT[ARTIFICIAL.ISGuid] = drNegResult[TABLE.RackTest.RackTestGuid];
								drAGT[ARTIFICIAL.ISRowVersion] = drNegResult[ARTIFICIAL.RackTestRowVersion];
							}
							else if (drNegResult[TABLE.RackTest.RackTestResultTypeCode].ToString().Trim() == ARTIFICIAL.RT)
							{
								if (drNegResult.IsNull(TABLE.RackTest.RackTestResult) == false)
								{
									drAGT[ARTIFICIAL.RT] = drNegResult[TABLE.RackTest.RackTestResult].ToString().Trim();
									drAGT[ARTIFICIAL.RTSave] = false;
								}
								else
								{
									drAGT[ARTIFICIAL.RT] = "";
									drAGT[ARTIFICIAL.RTSave] = true;
								}
								drAGT[ARTIFICIAL.RTGuid] = drNegResult[TABLE.RackTest.RackTestGuid];
								drAGT[ARTIFICIAL.RTRowVersion] = drNegResult[ARTIFICIAL.RackTestRowVersion];
							}
							else if (drNegResult[TABLE.RackTest.RackTestResultTypeCode].ToString().Trim() == ARTIFICIAL.C37)
							{
								if (drNegResult.IsNull(TABLE.RackTest.RackTestResult) == false)
								{
									drAGT[ARTIFICIAL.C37] = drNegResult[TABLE.RackTest.RackTestResult].ToString().Trim();
									drAGT[ARTIFICIAL.C37Save] = false;
								}
								else
								{
									drAGT[ARTIFICIAL.C37] = "";
									drAGT[ARTIFICIAL.C37Save] = true;
								}
								drAGT[ARTIFICIAL.C37Guid] = drNegResult[TABLE.RackTest.RackTestGuid];
								drAGT[ARTIFICIAL.C37RowVersion] = drNegResult[ARTIFICIAL.RackTestRowVersion];
							}
							else if (drNegResult[TABLE.RackTest.RackTestResultTypeCode].ToString().Trim() == ARTIFICIAL.AHG)
							{
								if (drNegResult.IsNull(TABLE.RackTest.RackTestResult) == false)
								{
									drAGT[ARTIFICIAL.AHG] = drNegResult[TABLE.RackTest.RackTestResult].ToString().Trim();
									drAGT[ARTIFICIAL.AHGSave] = false;
								}
								else
								{
									drAGT[ARTIFICIAL.AHG] = "";
									drAGT[ARTIFICIAL.AHGSave] = true;
								}
								drAGT[ARTIFICIAL.AHGGuid] = drNegResult[TABLE.RackTest.RackTestGuid];
								drAGT[ARTIFICIAL.AHGRowVersion] = drNegResult[ARTIFICIAL.RackTestRowVersion];
							}
							else if (drNegResult[TABLE.RackTest.RackTestResultTypeCode].ToString().Trim() == ARTIFICIAL.CC)
							{
								if (drNegResult.IsNull(TABLE.RackTest.RackTestResult) == false)
								{
									drAGT[ARTIFICIAL.CC] = drNegResult[TABLE.RackTest.RackTestResult].ToString().Trim();
									drAGT[ARTIFICIAL.CCSave] = false;
								}
								else
								{
									drAGT[ARTIFICIAL.CC] = "";
									drAGT[ARTIFICIAL.CCSave] = true;
								}
								drAGT[ARTIFICIAL.CCGuid] = drNegResult[TABLE.RackTest.RackTestGuid];
								drAGT[ARTIFICIAL.CCRowVersion] = drNegResult[ARTIFICIAL.RackTestRowVersion];
							}

							if(drNegResult.IsNull(TABLE.RackLot.SatisfactoryResultIndicator) == false)
							{
								if ((bool)drNegResult[TABLE.RackLot.SatisfactoryResultIndicator] == true)
								{
									drAGT[ARTIFICIAL.Interp] = "N";
									drAGT[ARTIFICIAL.InterpSave] = false;
								}
								else
								{
									drAGT[ARTIFICIAL.Interp] = "P";
									drAGT[ARTIFICIAL.InterpSave] = false;
								}
							}
							if (drNegResult.IsNull(TABLE.RackLot.Comments) == true)
							{
								drAGT[ARTIFICIAL.Comment] = "";
							}
							else
							{
								drAGT[ARTIFICIAL.Comment] = drNegResult[TABLE.RackLot.Comments];
							}
						}

						drAGT[ARTIFICIAL.TestType] = "NEG";
					}

					if (drAGT[ARTIFICIAL.TestType].ToString() == "NEG")
						drNeg = drAGT;
					else if (drAGT[ARTIFICIAL.TestType].ToString() == "POS")
						drPos = drAGT;
				}

				if (drControls.Length > 0 && WeakDTyping == false)
				{
					object[] objPatient = dtAGT.Rows[0].ItemArray;
					DataRow drPatient = dtAGT.NewRow();
					drPatient.ItemArray = objPatient;

					dtAGT.Rows.RemoveAt(0);
					dtAGT.Rows.Add(drPos);
					dtAGT.Rows.Add(drNeg);
					dtAGT.Rows.Add(drPatient);
				}

				foreach(DataRow dr in dtAGT.Rows)
				{
					dr[TABLE.ReagentType.ReactivityPhaseCode] = dtQCResults.Select("RecordStatusCode = 'A'")[0][TABLE.ReagentType.ReactivityPhaseCode];
				}
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/11/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2886"> 
		///		<ExpectedInput>DataTable containing the results of ABID testing, output DataTable that will be filled with specimen test data, output DataTable that will be filled with transfusion requirement data, valid datetime, valid tech id, valid testing method, rack identifier, empty auto instrument name</ExpectedInput>
		///		<ExpectedOutput>SpecimenTest table containing ABID testing results, PatientTransfusionRequirements DataTable containing new transfusion requirement for patient</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="0" testid ="7060"> 
		///		<ExpectedInput>DataTable containing the results of ABID testing, output DataTable that will be filled with specimen test data, output DataTable that will be filled with transfusion requirement data, valid datetime, valid tech id, valid testing method, empty rack identifier, valid auto instrument name, valid offsite indicator</ExpectedInput>
		///		<ExpectedOutput>SpecimenTest table containing ABID testing results, PatientTransfusionRequirements DataTable containing new transfusion requirement for patient</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="2887"> 
		///		<ExpectedInput>Invalid ABID DataTable, invalid SpecimenTest DataTable, invalid PatientTransfusionRequirement DataTable, invalid datetime, invalid tech id, invalid testing method, invalid rack identifier</ExpectedInput>
		///		<ExpectedOutput>NullReferenceException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method takes the results of antibody identification testing and converts them to DataTables
		/// that can be saved into appropriate tables in the database. The output consists of two DataTables
		/// one containing SpecimenTest data and the other one containing PatientTransfusionRequirements data
		/// because every antibody identified during tesing produces a new transfusion requirement for patient.
		/// BR_57.02
		/// </summary>
		/// <param name="dtABIDResults"></param>
		/// <param name="dtSpecimenTests"></param>
		/// <param name="dtTransfusionRequirements"></param>
		/// <param name="testingDateTime"></param>
		/// <param name="testingTechID"></param>
		/// <param name="RackGuid"></param>
		/// <param name="automatedInstrumentName"></param>
		/// <param name="automatedInstrumentQCd"></param>
		public static void BuildSpecimenTestRowsFromABID(DataTable dtABIDResults, 
														DataTable dtSpecimenTests, 
														DataTable dtTransfusionRequirements, 
														DateTime testingDateTime, 
														string testingTechID, 
														Guid RackGuid, 
														string automatedInstrumentName, 
														bool automatedInstrumentQCd)
		{
			DataTable dtPatientTransfusionRequirements;
			DataTable dtBloodTestTypes;

			dtBloodTestTypes = BOL.BloodTestType.GetBloodTestTypes(dtABIDResults.Rows[0][TABLE.BloodTestType.OrderableTestId].ToString());
			dtPatientTransfusionRequirements = BOL.PatientTransfusionRequirement.GetTransfusionRequirementsForPatient((Guid)dtABIDResults.Rows[0][TABLE.PatientSpecimen.PatientGuid]);

			foreach(DataRow drABID in dtABIDResults.Rows)
			{
				DataRow drSpecimenTest = dtSpecimenTests.NewRow();

				drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid] = Guid.NewGuid();
				drSpecimenTest[TABLE.SpecimenTest.OrderedTestGuid] = drABID[TABLE.SpecimenTest.OrderedTestGuid];
				drSpecimenTest[TABLE.SpecimenTest.PatientSpecimenGuid] = drABID[TABLE.SpecimenTest.PatientSpecimenGuid];
				drSpecimenTest[TABLE.SpecimenTest.CorrectedResultIndicator] = drABID[TABLE.SpecimenTest.CorrectedResultIndicator];
				drSpecimenTest[TABLE.SpecimenTest.TestTechId] = testingTechID;
				if (RackGuid == Guid.Empty)
				{
					drSpecimenTest[TABLE.SpecimenTest.RackGuid] = DBNull.Value;
				}
				else
				{
					drSpecimenTest[TABLE.SpecimenTest.RackGuid] = RackGuid;
				}
				drSpecimenTest[TABLE.SpecimenTest.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;

				drSpecimenTest[TABLE.SpecimenTest.TestDate] = testingDateTime;
				drSpecimenTest[TABLE.SpecimenTest.BloodTestTypeId] = dtBloodTestTypes.Select("BloodTestName LIKE '" + "*Serum Antibody ID*" + "'")[0][TABLE.SpecimenTest.BloodTestTypeId];
				drSpecimenTest[TABLE.SpecimenTest.AntibodyTypeId] = drABID[TABLE.SpecimenTest.AntibodyTypeId];
				drSpecimenTest[TABLE.SpecimenTest.TestComments] = drABID[TABLE.SpecimenTest.TestComments];
				if (automatedInstrumentName != "")
				{
					drSpecimenTest[TABLE.SpecimenTest.AutoInstrumentName] = automatedInstrumentName;
					drSpecimenTest[TABLE.SpecimenTest.AutoInstrumentQCIndicator] = automatedInstrumentQCd;
				}

				if ((bool)drABID[TABLE.SpecimenTest.OffsiteIndicator] == true)
				{
					drSpecimenTest[TABLE.SpecimenTest.OffsiteIndicator] = true;
					drSpecimenTest[TABLE.SpecimenTest.OffsiteLocation] = drABID[TABLE.SpecimenTest.OffsiteLocation];
					drSpecimenTest[TABLE.SpecimenTest.OffsiteCost] = drABID[TABLE.SpecimenTest.OffsiteCost];
				}
				
				dtSpecimenTests.Rows.Add(drSpecimenTest);

				if (drABID.IsNull(TABLE.SpecimenTest.AntibodyTypeId) == false)
				{
					if (dtPatientTransfusionRequirements.Select("AntibodyTypeId = " + (int)drABID[TABLE.SpecimenTest.AntibodyTypeId] + " AND TransfusionRequirementCategoryCode = 'AS' AND RecordStatusCode = 'A'").Length == 0)
					{
						DataRow drTransfusionRequirement = dtTransfusionRequirements.NewRow();
						drTransfusionRequirement[TABLE.PatientTransfusionRequirement.PatientTransfusionRequirementGuid] = Guid.NewGuid();
						drTransfusionRequirement[TABLE.PatientTransfusionRequirement.PatientGuid] = dtABIDResults.Rows[0][TABLE.PatientSpecimen.PatientGuid];
						drTransfusionRequirement[TABLE.PatientTransfusionRequirement.TransfusionRequirementText] = drABID[TABLE.AntibodyType.AntibodyTypeName];
						drTransfusionRequirement[TABLE.PatientTransfusionRequirement.TransfusionRequirementCategoryCode] = "AS";
						drTransfusionRequirement[TABLE.PatientTransfusionRequirement.CreateDate] = testingDateTime;
						drTransfusionRequirement[TABLE.PatientTransfusionRequirement.CreateUser] = testingTechID;
						drTransfusionRequirement[TABLE.PatientTransfusionRequirement.CreateDivisionCode] = Common.LogonUser.LogonUserDivisionCode;
						drTransfusionRequirement[TABLE.PatientTransfusionRequirement.VistaConversionIndicator] = false;
						drTransfusionRequirement[TABLE.PatientTransfusionRequirement.AntibodyTypeId] = drABID[TABLE.SpecimenTest.AntibodyTypeId];
						drTransfusionRequirement[TABLE.PatientTransfusionRequirement.RecordStatusCode] = "A";
						drTransfusionRequirement[TABLE.PatientTransfusion.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
						drTransfusionRequirement[TABLE.PatientTransfusionRequirement.SpecimenTestGuid] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];

						dtTransfusionRequirements.Rows.Add(drTransfusionRequirement);
					}
				}
			}
		}

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/15/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3030"> 
		///		<ExpectedInput>Valid results and specimen test tables, testing date/time, testing tech ID, test method, and rack GUID</ExpectedInput>
		///		<ExpectedOutput>Valid rows added to results table</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3031"> 
		///		<ExpectedInput>Invalid results and specimen test tables, testing date/time, testing tech ID, test method, and rack GUID</ExpectedInput>
		///		<ExpectedOutput>NullReferenceException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method takes the results of antibody screen testing and converts them to DataTables
		/// that can be saved into appropriate tables in the database. 
		/// </summary>
		public static void BuildSpecimenTestRowsFromABS(DataTable dtABSResults, DataTable dtSpecimenTestsInsert, DataTable dtSpecimenTestsUpdate, DateTime testingDateTime, string testingTechID, Common.ReactivityPhase reactivityPhase, string automatedInstrumentName, bool automatedInstrumentQCd)
		{
			DataTable dtBloodTestTypes;
			int rowNumber = 0;
			bool correctedResults = false;

			if (dtABSResults.Rows.Count > 0)
			{
				correctedResults = (bool)dtABSResults.Rows[0][TABLE.SpecimenTest.CorrectedResultIndicator];
			}

			foreach (DataRow drABSResults in dtABSResults.Rows)
			{
				dtBloodTestTypes = BOL.BloodTestType.GetBloodTestTypes(drABSResults[TABLE.BloodTestType.OrderableTestId].ToString());
				DataRow drSpecimenTest = null;
				bool update = false;

				rowNumber++;
				foreach(DataColumn col in drABSResults.Table.Columns)
				{
					if (drABSResults.IsNull(col) == false)
					{
						if ((col.ColumnName == ARTIFICIAL.IS) || (col.ColumnName == ARTIFICIAL.C37)  || (col.ColumnName == ARTIFICIAL.AHG) 
							|| (col.ColumnName == ARTIFICIAL.CC) || (col.ColumnName == ARTIFICIAL.ABSInterp)) 
						{
							if (col.ColumnName == ARTIFICIAL.ABSInterp && rowNumber > 1)
								continue;

							string saveColName = col.ColumnName + "Save";
							string guidColName = col.ColumnName + ARTIFICIAL.Guid;
							string rowVersionColName = col.ColumnName + TABLE.BloodUnit.RowVersion;

							if ((bool)drABSResults[saveColName] == false)
								continue;

							if (drABSResults.IsNull(guidColName) == true)
							{
								drSpecimenTest = dtSpecimenTestsInsert.NewRow();
								drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid] = Guid.NewGuid();
								dtSpecimenTestsInsert.Rows.Add(drSpecimenTest);
								update = false;
							}
							else
							{
								drSpecimenTest = dtSpecimenTestsUpdate.NewRow();
								drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid] = drABSResults[guidColName];
								drSpecimenTest[TABLE.SpecimenTest.RowVersion] = drABSResults[rowVersionColName];
								dtSpecimenTestsUpdate.Rows.Add(drSpecimenTest);
								update = true;
							}

							if ((bool)drABSResults[saveColName] == true)
							{
								string colTest = GetABSBloodTestColumnName(rowNumber, drABSResults["ScreeningCells"].ToString() == "Auto", col.ColumnName);
								drSpecimenTest[TABLE.SpecimenTest.BloodTestTypeId] = dtBloodTestTypes.Select("BloodTestName LIKE '" + "*" + colTest +  "*" + "'")[0][TABLE.SpecimenTest.BloodTestTypeId];
								if (drABSResults[col].ToString().Trim() != "")
									drSpecimenTest[TABLE.SpecimenTest.TestResultId] = drABSResults[col];
								else
									drSpecimenTest[TABLE.SpecimenTest.TestResultId] = DBNull.Value;
								drSpecimenTest[TABLE.SpecimenTest.TestComments] = dtABSResults.Rows[0]["ABSComment"];
							}

							if (update == false)
							{
								drSpecimenTest[TABLE.SpecimenTest.OrderedTestGuid] = drABSResults[TABLE.SpecimenTest.OrderedTestGuid];
								drSpecimenTest[TABLE.SpecimenTest.PatientSpecimenGuid] = drABSResults[TABLE.SpecimenTest.PatientSpecimenGuid];
								drSpecimenTest[TABLE.SpecimenTest.CorrectedResultIndicator] = correctedResults;
								drSpecimenTest[TABLE.SpecimenTest.RackGuid] = drABSResults[TABLE.Rack.RackGuid];

								drSpecimenTest[TABLE.SpecimenTest.ReactivityPhaseCode] = Convert.ToString(((int)reactivityPhase))[0];
								
								if (automatedInstrumentName != "")
								{
									drSpecimenTest[TABLE.SpecimenTest.AutoInstrumentName] = automatedInstrumentName;
									drSpecimenTest[TABLE.SpecimenTest.AutoInstrumentQCIndicator] = automatedInstrumentQCd;
								}
							}
							drSpecimenTest[TABLE.SpecimenTest.TestTechId] = testingTechID;
							drSpecimenTest[TABLE.SpecimenTest.TestDate] = testingDateTime;
							drSpecimenTest[TABLE.SpecimenTest.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
						}
					}
				}
			}
		}

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/15/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3032"> 
		///		<ExpectedInput>Valid data table and test objects</ExpectedInput>
		///		<ExpectedOutput>No exceptions</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3033"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// This method takes the results of antibody screen and converts it to a DataTable
		/// that can be saved into appropriate tables in the database. 
		/// </summary>
		/// <param name="dtABS"></param>
		/// <param name="test"></param>
		public static void BuildABSFromSpecimenTest(DataTable dtABS, BOL.OrderedTest test)
		{
			string BloodTestType = "";
			DataTable dtBloodTestTypes = BOL.BloodTestType.GetBloodTestTypes(test.OrderableTestId.ToString());
			DataTable dtSpecimenTests = DAL.OrderedTest.GetTestResultsForTask(test.OrderedTestGuid);
			bool sc1Exists = false;
			bool sc2Exists = false;
			bool sc3Exists = false;
			bool sc4Exists = false;
			bool autoExists = false;
			int reactivityPhase = -1;

			if (dtSpecimenTests.Select("BloodTestName LIKE '*Screen*' OR BloodTestName LIKE '*Auto Control*'").Length == 0)
				return;

			int numRows = dtABS.Rows.Count - 1;
			foreach(DataRow drSpecimenTest in dtSpecimenTests.Rows)
			{	
				if (dtBloodTestTypes.Select("BloodTestTypeId = '" + drSpecimenTest[TABLE.SpecimenTest.BloodTestTypeId].ToString() + "'").Length > 0)
				{
					BloodTestType = dtBloodTestTypes.Select("BloodTestTypeId = '" + drSpecimenTest[TABLE.SpecimenTest.BloodTestTypeId].ToString() + "'")[0][TABLE.BloodTestType.BloodTestName].ToString();
				}
				else
				{
					continue;
				}

				if (drSpecimenTest.IsNull(TABLE.SpecimenTest.ReactivityPhaseCode) == false)
					reactivityPhase = Convert.ToInt32(drSpecimenTest[TABLE.SpecimenTest.ReactivityPhaseCode].ToString());

				if (drSpecimenTest.IsNull(TABLE.SpecimenTest.CorrectedResultIndicator))
				{
					dtABS.Rows[0][TABLE.SpecimenTest.CorrectedResultIndicator] = false;
				}
				else
				{
					dtABS.Rows[0][TABLE.SpecimenTest.CorrectedResultIndicator] = (bool)drSpecimenTest[TABLE.SpecimenTest.CorrectedResultIndicator];
				}

				switch (BloodTestType)
				{
					case "Plasma + Screen I IS":
						sc1Exists = true;
						if (drSpecimenTest.IsNull(TABLE.SpecimenTest.TestResultId) == false)
						{
							dtABS.Rows[0][ARTIFICIAL.IS] = drSpecimenTest[TABLE.SpecimenTest.TestResultId].ToString().Trim();
							dtABS.Rows[0][ARTIFICIAL.ISSave] = false;
						}
						else
						{
							dtABS.Rows[0][ARTIFICIAL.IS] = "";
							dtABS.Rows[0][ARTIFICIAL.ISSave] = true;
						}
						dtABS.Rows[0][ARTIFICIAL.ISGuid] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];
						dtABS.Rows[0][ARTIFICIAL.ISRowVersion] = drSpecimenTest[TABLE.SpecimenTest.RowVersion];
						if (drSpecimenTest.IsNull(TABLE.Rack.RackGuid) == false)
							dtABS.Rows[0][TABLE.Rack.RackGuid] = (Guid)drSpecimenTest[TABLE.Rack.RackGuid];
						break;
					case "Plasma + Screen I 37C":
						sc1Exists = true;
						if (drSpecimenTest.IsNull(TABLE.SpecimenTest.TestResultId) == false)
						{
							dtABS.Rows[0][ARTIFICIAL.C37] = drSpecimenTest[TABLE.SpecimenTest.TestResultId].ToString().Trim();
							dtABS.Rows[0][ARTIFICIAL.C37Save] = false;
						}
						else
						{
							dtABS.Rows[0][ARTIFICIAL.C37] = "";
							dtABS.Rows[0][ARTIFICIAL.C37Save] = true;
						}
						dtABS.Rows[0][ARTIFICIAL.C37Guid] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];
						dtABS.Rows[0][ARTIFICIAL.C37RowVersion] = drSpecimenTest[TABLE.SpecimenTest.RowVersion];
						if (drSpecimenTest.IsNull(TABLE.Rack.RackGuid) == false)
							dtABS.Rows[0][TABLE.Rack.RackGuid] = (Guid)drSpecimenTest[TABLE.Rack.RackGuid];
						break;
					case "Plasma + Screen I AHG":
						sc1Exists = true;
						if (drSpecimenTest.IsNull(TABLE.SpecimenTest.TestResultId) == false)
						{
							dtABS.Rows[0][ARTIFICIAL.AHG] = drSpecimenTest[TABLE.SpecimenTest.TestResultId].ToString().Trim();
							dtABS.Rows[0][ARTIFICIAL.AHGSave] = false;
						}
						else
						{
							dtABS.Rows[0][ARTIFICIAL.AHG] = "";
							dtABS.Rows[0][ARTIFICIAL.AHGSave] = true;
						}
						dtABS.Rows[0][ARTIFICIAL.AHGGuid] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];
						dtABS.Rows[0][ARTIFICIAL.AHGRowVersion] = drSpecimenTest[TABLE.SpecimenTest.RowVersion];
						if (drSpecimenTest.IsNull(TABLE.Rack.RackGuid) == false)
							dtABS.Rows[0][TABLE.Rack.RackGuid] = (Guid)drSpecimenTest[TABLE.Rack.RackGuid];
						break;
					case "Plasma + Screen I CC":
						sc1Exists = true;
						if (drSpecimenTest.IsNull(TABLE.SpecimenTest.TestResultId) == false)
						{
							dtABS.Rows[0][ARTIFICIAL.CC] = drSpecimenTest[TABLE.SpecimenTest.TestResultId].ToString().Trim();
							dtABS.Rows[0][ARTIFICIAL.CCSave] = false;
						}
						else
						{
							dtABS.Rows[0][ARTIFICIAL.CC] = "";
							dtABS.Rows[0][ARTIFICIAL.CCSave] = true;
						}
						dtABS.Rows[0][ARTIFICIAL.CCGuid] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];
						dtABS.Rows[0][ARTIFICIAL.CCRowVersion] = drSpecimenTest[TABLE.SpecimenTest.RowVersion];
						if (drSpecimenTest.IsNull(TABLE.Rack.RackGuid) == false)
							dtABS.Rows[0][TABLE.Rack.RackGuid] = (Guid)drSpecimenTest[TABLE.Rack.RackGuid];
						break;
					case "Plasma + Screen II IS":
						sc2Exists = true;
						if (drSpecimenTest.IsNull(TABLE.SpecimenTest.TestResultId) == false)
						{
							dtABS.Rows[1][ARTIFICIAL.IS] = drSpecimenTest[TABLE.SpecimenTest.TestResultId].ToString().Trim();
							dtABS.Rows[1][ARTIFICIAL.ISSave] = false;
						}
						else
						{
							dtABS.Rows[1][ARTIFICIAL.IS] = "";
							dtABS.Rows[1][ARTIFICIAL.ISSave] = true;
						}
						dtABS.Rows[1][ARTIFICIAL.ISGuid] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];
						dtABS.Rows[1][ARTIFICIAL.ISRowVersion] = drSpecimenTest[TABLE.SpecimenTest.RowVersion];
						if (drSpecimenTest.IsNull(TABLE.Rack.RackGuid) == false)
							dtABS.Rows[1][TABLE.Rack.RackGuid] = (Guid)drSpecimenTest[TABLE.Rack.RackGuid];
						break;
					case "Plasma + Screen II 37C":
						sc2Exists = true;
						if (drSpecimenTest.IsNull(TABLE.SpecimenTest.TestResultId) == false)
						{
							dtABS.Rows[1][ARTIFICIAL.C37] = drSpecimenTest[TABLE.SpecimenTest.TestResultId].ToString().Trim();
							dtABS.Rows[1][ARTIFICIAL.C37Save] = false;
						}
						else
						{
							dtABS.Rows[1][ARTIFICIAL.C37] = "";
							dtABS.Rows[1][ARTIFICIAL.C37Save] = true;
						}
						dtABS.Rows[1][ARTIFICIAL.C37Guid] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];
						dtABS.Rows[1][ARTIFICIAL.C37RowVersion] = drSpecimenTest[TABLE.SpecimenTest.RowVersion];
						if (drSpecimenTest.IsNull(TABLE.Rack.RackGuid) == false)
							dtABS.Rows[1][TABLE.Rack.RackGuid] = (Guid)drSpecimenTest[TABLE.Rack.RackGuid];
						break;
					case "Plasma + Screen II AHG":
						sc2Exists = true;
						if (drSpecimenTest.IsNull(TABLE.SpecimenTest.TestResultId) == false)
						{
							dtABS.Rows[1][ARTIFICIAL.AHG] = drSpecimenTest[TABLE.SpecimenTest.TestResultId].ToString().Trim();
							dtABS.Rows[1][ARTIFICIAL.AHGSave] = false;
						}
						else
						{
							dtABS.Rows[1][ARTIFICIAL.AHG] = "";
							dtABS.Rows[1][ARTIFICIAL.AHGSave] = true;
						}
						dtABS.Rows[1][ARTIFICIAL.AHGGuid] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];
						dtABS.Rows[1][ARTIFICIAL.AHGRowVersion] = drSpecimenTest[TABLE.SpecimenTest.RowVersion];
						if (drSpecimenTest.IsNull(TABLE.Rack.RackGuid) == false)
							dtABS.Rows[1][TABLE.Rack.RackGuid] = (Guid)drSpecimenTest[TABLE.Rack.RackGuid];
						break;
					case "Plasma + Screen II CC":
						sc2Exists = true;
						if (drSpecimenTest.IsNull(TABLE.SpecimenTest.TestResultId) == false)
						{
							dtABS.Rows[1][ARTIFICIAL.CC] = drSpecimenTest[TABLE.SpecimenTest.TestResultId].ToString().Trim();
							dtABS.Rows[1][ARTIFICIAL.CCSave] = false;
						}
						else
						{
							dtABS.Rows[1][ARTIFICIAL.CC] = "";
							dtABS.Rows[1][ARTIFICIAL.CCSave] = true;
						}
						dtABS.Rows[1][ARTIFICIAL.CCGuid] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];
						dtABS.Rows[1][ARTIFICIAL.CCRowVersion] = drSpecimenTest[TABLE.SpecimenTest.RowVersion];
						if (drSpecimenTest.IsNull(TABLE.Rack.RackGuid) == false)
							dtABS.Rows[1][TABLE.Rack.RackGuid] = (Guid)drSpecimenTest[TABLE.Rack.RackGuid];
						break;
					case "Plasma + Screen III IS":
						sc3Exists = true;
						if (drSpecimenTest.IsNull(TABLE.SpecimenTest.TestResultId) == false)
						{
							dtABS.Rows[2][ARTIFICIAL.IS] = drSpecimenTest[TABLE.SpecimenTest.TestResultId].ToString().Trim();
							dtABS.Rows[2][ARTIFICIAL.ISSave] = false;
						}
						else
						{
							dtABS.Rows[2][ARTIFICIAL.IS] = "";
							dtABS.Rows[2][ARTIFICIAL.ISSave] = true;
						}
						dtABS.Rows[2][ARTIFICIAL.ISGuid] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];
						dtABS.Rows[2][ARTIFICIAL.ISRowVersion] = drSpecimenTest[TABLE.SpecimenTest.RowVersion];
						if (drSpecimenTest.IsNull(TABLE.Rack.RackGuid) == false)
							dtABS.Rows[2][TABLE.Rack.RackGuid] = (Guid)drSpecimenTest[TABLE.Rack.RackGuid];
						break;
					case "Plasma + Screen III 37C":
						sc3Exists = true;
						if (drSpecimenTest.IsNull(TABLE.SpecimenTest.TestResultId) == false)
						{
							dtABS.Rows[2][ARTIFICIAL.C37] = drSpecimenTest[TABLE.SpecimenTest.TestResultId].ToString().Trim();
							dtABS.Rows[2][ARTIFICIAL.C37Save] = false;
						}
						else
						{
							dtABS.Rows[2][ARTIFICIAL.C37] = "";
							dtABS.Rows[2][ARTIFICIAL.C37Save] = true;
						}
						dtABS.Rows[2][ARTIFICIAL.C37Guid] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];
						dtABS.Rows[2][ARTIFICIAL.C37RowVersion] = drSpecimenTest[TABLE.SpecimenTest.RowVersion];
						if (drSpecimenTest.IsNull(TABLE.Rack.RackGuid) == false)
							dtABS.Rows[2][TABLE.Rack.RackGuid] = (Guid)drSpecimenTest[TABLE.Rack.RackGuid];
						break;
					case "Plasma + Screen III AHG":
						sc3Exists = true;
						if (drSpecimenTest.IsNull(TABLE.SpecimenTest.TestResultId) == false)
						{
							dtABS.Rows[2][ARTIFICIAL.AHG] = drSpecimenTest[TABLE.SpecimenTest.TestResultId].ToString().Trim();
							dtABS.Rows[2][ARTIFICIAL.AHGSave] = false;
						}
						else
						{
							dtABS.Rows[2][ARTIFICIAL.AHG] = "";
							dtABS.Rows[2][ARTIFICIAL.AHGSave] = true;
						}
						dtABS.Rows[2][ARTIFICIAL.AHGGuid] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];
						dtABS.Rows[2][ARTIFICIAL.AHGRowVersion] = drSpecimenTest[TABLE.SpecimenTest.RowVersion];
						if (drSpecimenTest.IsNull(TABLE.Rack.RackGuid) == false)
							dtABS.Rows[2][TABLE.Rack.RackGuid] = (Guid)drSpecimenTest[TABLE.Rack.RackGuid];
						break;
					case "Plasma + Screen III CC":
						sc3Exists = true;
						if (drSpecimenTest.IsNull(TABLE.SpecimenTest.TestResultId) == false)
						{
							dtABS.Rows[2][ARTIFICIAL.CC] = drSpecimenTest[TABLE.SpecimenTest.TestResultId].ToString().Trim();
							dtABS.Rows[2][ARTIFICIAL.CCSave] = false;
						}
						else
						{
							dtABS.Rows[2][ARTIFICIAL.CC] = "";
							dtABS.Rows[2][ARTIFICIAL.CCSave] = true;
						}
						dtABS.Rows[2][ARTIFICIAL.CCGuid] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];
						dtABS.Rows[2][ARTIFICIAL.CCRowVersion] = drSpecimenTest[TABLE.SpecimenTest.RowVersion];
						if (drSpecimenTest.IsNull(TABLE.Rack.RackGuid) == false)
							dtABS.Rows[2][TABLE.Rack.RackGuid] = (Guid)drSpecimenTest[TABLE.Rack.RackGuid];
						break;
					case "Plasma + Screen IV IS":
						sc4Exists = true;
						if (drSpecimenTest.IsNull(TABLE.SpecimenTest.TestResultId) == false)
						{
							dtABS.Rows[3][ARTIFICIAL.IS] = drSpecimenTest[TABLE.SpecimenTest.TestResultId].ToString().Trim();
							dtABS.Rows[3][ARTIFICIAL.ISSave] = false;
						}
						else
						{
							dtABS.Rows[3][ARTIFICIAL.IS] = "";
							dtABS.Rows[3][ARTIFICIAL.ISSave] = true;
						}
						dtABS.Rows[3][ARTIFICIAL.ISGuid] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];
						dtABS.Rows[3][ARTIFICIAL.ISRowVersion] = drSpecimenTest[TABLE.SpecimenTest.RowVersion];
						if (drSpecimenTest.IsNull(TABLE.Rack.RackGuid) == false)
							dtABS.Rows[3][TABLE.Rack.RackGuid] = (Guid)drSpecimenTest[TABLE.Rack.RackGuid];
						break;
					case "Plasma + Screen IV 37C":
						sc4Exists = true;
						if (drSpecimenTest.IsNull(TABLE.SpecimenTest.TestResultId) == false)
						{
							dtABS.Rows[3][ARTIFICIAL.C37] = drSpecimenTest[TABLE.SpecimenTest.TestResultId].ToString().Trim();
							dtABS.Rows[3][ARTIFICIAL.C37Save] = false;
						}
						else
						{
							dtABS.Rows[3][ARTIFICIAL.C37] = "";
							dtABS.Rows[3][ARTIFICIAL.C37Save] = true;
						}
						dtABS.Rows[3][ARTIFICIAL.C37Guid] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];
						dtABS.Rows[3][ARTIFICIAL.C37RowVersion] = drSpecimenTest[TABLE.SpecimenTest.RowVersion];
						if (drSpecimenTest.IsNull(TABLE.Rack.RackGuid) == false)
							dtABS.Rows[3][TABLE.Rack.RackGuid] = (Guid)drSpecimenTest[TABLE.Rack.RackGuid];
						break;
					case "Plasma + Screen IV AHG":
						sc4Exists = true;
						if (drSpecimenTest.IsNull(TABLE.SpecimenTest.TestResultId) == false)
						{
							dtABS.Rows[3][ARTIFICIAL.AHG] = drSpecimenTest[TABLE.SpecimenTest.TestResultId].ToString().Trim();
							dtABS.Rows[3][ARTIFICIAL.AHGSave] = false;
						}
						else
						{
							dtABS.Rows[3][ARTIFICIAL.AHG] = "";
							dtABS.Rows[3][ARTIFICIAL.AHGSave] = true;
						}
						dtABS.Rows[3][ARTIFICIAL.AHGGuid] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];
						dtABS.Rows[3][ARTIFICIAL.AHGRowVersion] = drSpecimenTest[TABLE.SpecimenTest.RowVersion];
						if (drSpecimenTest.IsNull(TABLE.Rack.RackGuid) == false)
							dtABS.Rows[3][TABLE.Rack.RackGuid] = (Guid)drSpecimenTest[TABLE.Rack.RackGuid];
						break;
					case "Plasma + Screen IV CC":
						sc4Exists = true;
						if (drSpecimenTest.IsNull(TABLE.SpecimenTest.TestResultId) == false)
						{
							dtABS.Rows[3][ARTIFICIAL.CC] = drSpecimenTest[TABLE.SpecimenTest.TestResultId].ToString().Trim();
							dtABS.Rows[3][ARTIFICIAL.CCSave] = false;
						}
						else
						{
							dtABS.Rows[3][ARTIFICIAL.CC] = "";
							dtABS.Rows[3][ARTIFICIAL.CCSave] = true;
						}
						dtABS.Rows[3][ARTIFICIAL.CCGuid] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];
						dtABS.Rows[3][ARTIFICIAL.CCRowVersion] = drSpecimenTest[TABLE.SpecimenTest.RowVersion];
						if (drSpecimenTest.IsNull(TABLE.Rack.RackGuid) == false)
							dtABS.Rows[3][TABLE.Rack.RackGuid] = (Guid)drSpecimenTest[TABLE.Rack.RackGuid];
						break;
					case "Auto Control IS":
						autoExists = true;
						if (drSpecimenTest.IsNull(TABLE.SpecimenTest.TestResultId) == false)
						{
							dtABS.Rows[numRows][ARTIFICIAL.IS] = drSpecimenTest[TABLE.SpecimenTest.TestResultId].ToString().Trim();
							dtABS.Rows[numRows][ARTIFICIAL.ISSave] = false;
						}
						else
						{
							dtABS.Rows[numRows][ARTIFICIAL.IS] = "";
							dtABS.Rows[numRows][ARTIFICIAL.ISSave] = true;
						}
						dtABS.Rows[numRows][ARTIFICIAL.ISGuid] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];
						dtABS.Rows[numRows][ARTIFICIAL.ISRowVersion] = drSpecimenTest[TABLE.SpecimenTest.RowVersion];
						if (drSpecimenTest.IsNull(TABLE.Rack.RackGuid) == false)
							dtABS.Rows[numRows][TABLE.Rack.RackGuid] = (Guid)drSpecimenTest[TABLE.Rack.RackGuid];
						break;
					case "Auto Control 37C":
						autoExists = true;
						if (drSpecimenTest.IsNull(TABLE.SpecimenTest.TestResultId) == false)
						{
							dtABS.Rows[numRows][ARTIFICIAL.C37] = drSpecimenTest[TABLE.SpecimenTest.TestResultId].ToString().Trim();
							dtABS.Rows[numRows][ARTIFICIAL.C37Save] = false;
						}
						else
						{
							dtABS.Rows[numRows][ARTIFICIAL.C37] = "";
							dtABS.Rows[numRows][ARTIFICIAL.C37Save] = true;
						}
						dtABS.Rows[numRows][ARTIFICIAL.C37Guid] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];
						dtABS.Rows[numRows][ARTIFICIAL.C37RowVersion] = drSpecimenTest[TABLE.SpecimenTest.RowVersion];
						if (drSpecimenTest.IsNull(TABLE.Rack.RackGuid) == false)
							dtABS.Rows[numRows][TABLE.Rack.RackGuid] = (Guid)drSpecimenTest[TABLE.Rack.RackGuid];
						break;
					case "Auto Control AHG":
						autoExists = true;
						if (drSpecimenTest.IsNull(TABLE.SpecimenTest.TestResultId) == false)
						{
							dtABS.Rows[numRows][ARTIFICIAL.AHG] = drSpecimenTest[TABLE.SpecimenTest.TestResultId].ToString().Trim();
							dtABS.Rows[numRows][ARTIFICIAL.AHGSave] = false;
						}
						else
						{
							dtABS.Rows[numRows][ARTIFICIAL.AHG] = "";
							dtABS.Rows[numRows][ARTIFICIAL.AHGSave] = true;
						}
						dtABS.Rows[numRows][ARTIFICIAL.AHGGuid] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];
						dtABS.Rows[numRows][ARTIFICIAL.AHGRowVersion] = drSpecimenTest[TABLE.SpecimenTest.RowVersion];
						if (drSpecimenTest.IsNull(TABLE.Rack.RackGuid) == false)
							dtABS.Rows[numRows][TABLE.Rack.RackGuid] = (Guid)drSpecimenTest[TABLE.Rack.RackGuid];
						break;
					case "Auto Control CC":
						autoExists = true;
						if (drSpecimenTest.IsNull(TABLE.SpecimenTest.TestResultId) == false)
						{
							dtABS.Rows[numRows][ARTIFICIAL.CC] = drSpecimenTest[TABLE.SpecimenTest.TestResultId].ToString().Trim();
							dtABS.Rows[numRows][ARTIFICIAL.CCSave] = false;
						}
						else
						{
							dtABS.Rows[numRows][ARTIFICIAL.CC] = "";
							dtABS.Rows[numRows][ARTIFICIAL.CCSave] = true;
						}
						dtABS.Rows[numRows][ARTIFICIAL.CCGuid] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];
						dtABS.Rows[numRows][ARTIFICIAL.CCRowVersion] = drSpecimenTest[TABLE.SpecimenTest.RowVersion];
						if (drSpecimenTest.IsNull(TABLE.Rack.RackGuid) == false)
							dtABS.Rows[numRows][TABLE.Rack.RackGuid] = (Guid)drSpecimenTest[TABLE.Rack.RackGuid];
						break;
					case "Antibody Screen Interp":
						if (drSpecimenTest.IsNull(TABLE.SpecimenTest.TestResultId) == false)
						{
							dtABS.Rows[0][ARTIFICIAL.ABSInterp] = drSpecimenTest[TABLE.SpecimenTest.TestResultId].ToString().Trim();
							dtABS.Rows[0][ARTIFICIAL.ABSInterpSave] = false;
						}
						else
						{
							dtABS.Rows[0][ARTIFICIAL.ABSInterp] = "";
							dtABS.Rows[0][ARTIFICIAL.ABSInterpSave] = true;
						}
						dtABS.Rows[0][ARTIFICIAL.ABSInterpGuid] = drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid];
						dtABS.Rows[0][ARTIFICIAL.ABSInterpRowVersion] = drSpecimenTest[TABLE.SpecimenTest.RowVersion];
						if (drSpecimenTest.IsNull(TABLE.Rack.RackGuid) == false)
							dtABS.Rows[0][TABLE.Rack.RackGuid] = (Guid)drSpecimenTest[TABLE.Rack.RackGuid];
						break;
					
					default:
						break;
				}
			}

			if (autoExists || sc4Exists || sc3Exists || sc2Exists || sc1Exists)
			{
				if (autoExists == false)
					dtABS.Rows.RemoveAt(4);

				if (sc4Exists == false)
					dtABS.Rows.RemoveAt(3);

				if (sc3Exists == false)
					dtABS.Rows.RemoveAt(2);

				if (sc2Exists == false)
					dtABS.Rows.RemoveAt(1);

				if (sc1Exists == false)
					dtABS.Rows.RemoveAt(0);

				if (reactivityPhase == Convert.ToInt32(Common.ReactivityPhase.IAT))
				{
					foreach(DataRow dr in dtABS.Rows)
					{
						dr[ARTIFICIAL.IS] = null;
						dr[ARTIFICIAL.C37] = null;
						dr[ARTIFICIAL.CC] = null;
						dr[ARTIFICIAL.ISSave] = false;
						dr[ARTIFICIAL.C37Save] = false;
						dr[ARTIFICIAL.CCSave] = false;		
					}
				}
			}
		}

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/15/2003</CreationDate>
		///
		/// <summary>
		/// Returns the name of a valid BloodTestType column
		/// </summary>
		/// <param name="rowNumber"></param>
		/// <param name="isAuto"></param>
		/// <param name="colName"></param>
		/// <returns></returns>
		private static string GetABSBloodTestColumnName(int rowNumber, bool isAuto, string colName)
		{
			string romanNumeral = string.Empty;

			if (colName == ARTIFICIAL.ABSInterp)
			{
				return "Antibody Screen Interp";
			}

			if (isAuto)
			{
				return "Auto Control " + colName;
			}
			
			switch (rowNumber)
			{
				case 1:
					romanNumeral = "I";
					break;
				case 2:
					romanNumeral = "II";
					break;
				case 3:
					romanNumeral = "III";
					break;
				case 4:
					romanNumeral = "IV";
					break;
			}
			return string.Concat("Plasma + Screen ", romanNumeral, " ", colName);
		}


		
		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/15/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2960"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>null</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2963"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		///  Loads a data row from an object
		/// </summary>
		public override System.Data.DataRow LoadDataRowFromThis(System.Data.DataRow dataRow)
		{
			return null;
		}

		/// <summary>
		/// Loads an object from a data row 
		/// </summary>
		protected override void LoadFromDataRow(System.Data.DataRow dataRow)
		{
			//
			this._specimenTestRow = dataRow;
			if (dataRow.Table.Columns.Contains(TABLE.SpecimenTest.OrderedTestGuid)&&
				dataRow.Table.Columns.Contains(TABLE.PatientOrder.PatientOrderGuid))
			{
				if (!dataRow.IsNull(TABLE.SpecimenTest.OrderedTestGuid)&&
					!dataRow.IsNull(TABLE.PatientOrder.PatientOrderGuid))
				{
					this._orderedTest = new BOL.OrderedTest((Guid)dataRow[TABLE.SpecimenTest.OrderedTestGuid],(Guid)dataRow[TABLE.PatientOrder.PatientOrderGuid]);
				}
			}
			if (dataRow.Table.Columns.Contains(TABLE.SpecimenTest.TestingMethodCode) && 
				!dataRow.IsNull(TABLE.SpecimenTest.TestingMethodCode))
			{
				this._testingMethod = new BOL.TestingMethod(dataRow[TABLE.SpecimenTest.TestingMethodCode].ToString());
			}
//			if (dataRow.Table.Columns.Contains[TABLE.SpecimenTest.TestDate] &&
//				!dataRow.IsNull(TABLE.SpecimenTest.TestDate))
//			{
//				this.TestDate = new BOL.Rack((Guid)dataRow[TABLE.SpecimenTest.TestDate]);
//			}
//			if (dataRow.Table.Columns.Contains[TABLE.SpecimenTest.TestComments] &&
//				!dataRow.IsNull(TABLE.SpecimenTest.TestComments))
//			{
//				this.TestDate = new BOL.Rack((Guid)dataRow[TABLE.SpecimenTest.TestDate]);
//			}
			if (dataRow.Table.Columns.Contains(TABLE.SpecimenTest.RackGuid) &&
				!dataRow.IsNull(TABLE.SpecimenTest.RackGuid))
			{
				this._rack = new BOL.Rack((Guid)dataRow[TABLE.SpecimenTest.RackGuid]);
			}
			if (dataRow.Table.Columns.Contains(TABLE.SpecimenTest.BloodTestTypeId) && 
				!dataRow.IsNull(TABLE.SpecimenTest.BloodTestTypeId))
			{
				this._bloodTestType = new BOL.BloodTestType((int)dataRow[TABLE.SpecimenTest.BloodTestTypeId]);
			}
			if (dataRow.Table.Columns.Contains(TABLE.SpecimenTest.TestResultId) &&
				!dataRow.IsNull(TABLE.SpecimenTest.TestResultId))
			{
				this._testResult = new BOL.TestResult(dataRow[TABLE.SpecimenTest.TestResultId].ToString());
			}
			if (dataRow.Table.Columns.Contains(TABLE.SpecimenTest.AntibodyTypeId) &&
				!dataRow.IsNull(TABLE.SpecimenTest.AntibodyTypeId))
			{
				this._antibodyType = new BOL.AntibodyType((int)dataRow[TABLE.SpecimenTest.AntibodyTypeId]);
			}
			if (dataRow.Table.Columns.Contains(TABLE.SpecimenTest.RowVersion) &&
				!dataRow.IsNull(TABLE.SpecimenTest.RowVersion))
			{
				this.RowVersion = (byte[])dataRow[TABLE.SpecimenTest.RowVersion];
			}
			//
			this._specimenTestRow.AcceptChanges();
		}

		



		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>4/22/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4115"> 
		///		<ExpectedInput>Valid ABO/Rh test results to be invalidated</ExpectedInput>
		///		<ExpectedOutput>Success indicator of true</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4116"> 
		///		<ExpectedInput>Invlaid test results to be invalidated</ExpectedInput>
		///		<ExpectedOutput>Success indicator of false</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="0" testid ="7041"> 
		///		<ExpectedInput>Valid ABID test results to be invalidated</ExpectedInput>
		///		<ExpectedOutput>Success indicator of true</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Implements BR_94.04, BR_94.07, BR_94.08, BR_94.10, BR_94.12
		/// </summary>
		/// <param name="specimenTests"></param>
		/// <param name="invalidateComment"></param>
		/// <param name="replaceResults"></param>
		/// <param name="lastUpdateFunction"></param>
		/// <param name="alWorkloadProcessIds"></param>
		/// <param name="patientGuid"></param>
		/// <param name="patientRowVersion"></param>
		/// <returns></returns>
		public static bool InvalidateSpecimenTestResults(System.Collections.ArrayList specimenTests, string invalidateComment, 
			bool replaceResults, Common.UpdateFunction lastUpdateFunction, System.Collections.ArrayList alWorkloadProcessIds,
			Guid patientGuid, byte[] patientRowVersion)
		{
			//
			DateTime currentDateTime = VBECSDateTime.GetDivisionCurrentDateTime();
			DataTable dtWorkloadEvent = null;
			DataTable updateAntiseraOrderedTests = null;
			//
			DataTable transfusionReqs = new DataTable(TABLE.PatientTransfusionRequirement.TableName);
			transfusionReqs.Columns.Add(TABLE.PatientTransfusionRequirement.PatientTransfusionRequirementGuid, typeof(System.Guid));
			transfusionReqs.Columns.Add(TABLE.PatientTransfusionRequirement.InactivationComment, typeof(string));
			transfusionReqs.Columns.Add(TABLE.PatientTransfusionRequirement.InactivateDate, typeof(System.DateTime));
			transfusionReqs.Columns.Add(TABLE.PatientTransfusionRequirement.InactivateUser, typeof(string));
			transfusionReqs.Columns.Add(TABLE.PatientTransfusionRequirement.InactivateDivisionCode, typeof(string));
			transfusionReqs.Columns.Add(TABLE.PatientTransfusionRequirement.RecordStatusCode, typeof(string));
			transfusionReqs.Columns.Add(TABLE.PatientTransfusionRequirement.RowVersion, typeof(byte[]));
			transfusionReqs.Columns.Add(TABLE.PatientTransfusion.DivisionCode, typeof(string));

			DataTable dtTransfusionRequirements = BOL.PatientTransfusionRequirement.GetTransfusionRequirementsForPatient(patientGuid);
			DataTable dtPatient = new DataTable();
			dtPatient.Columns.Add(TABLE.Patient.PatientGuid, typeof(System.Guid));
			dtPatient.Columns.Add(TABLE.Patient.AboRhChangeIndicator, typeof(byte));
			dtPatient.Columns.Add(TABLE.Patient.RowVersion, typeof(byte[]));
			//
			DataTable dtSpecimenTest = new DataTable(TABLE.SpecimenTest.TableName);
			dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.SpecimenTestGuid, typeof(Guid));
			dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.RecordStatusCode, typeof(char));
			dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.TestComments, typeof(string));
			dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.InactivateDate, typeof(DateTime));
			dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.InactivateUser, typeof(string));
			dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.RowVersion, typeof(byte[]));
			dtSpecimenTest.Columns.Add(TABLE.SpecimenTest.DivisionCode, typeof(string));
			foreach(BOL.SpecimenTest test in specimenTests)
			{
				DataRow drSpecimenTest = dtSpecimenTest.NewRow();
				drSpecimenTest[TABLE.SpecimenTest.SpecimenTestGuid] = test.SpecimenTestGuid;
				drSpecimenTest[TABLE.SpecimenTest.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.ErrorCorrected);
				drSpecimenTest[TABLE.SpecimenTest.TestComments] = invalidateComment;
				drSpecimenTest[TABLE.SpecimenTest.InactivateDate] = currentDateTime;
				drSpecimenTest[TABLE.SpecimenTest.InactivateUser] = Common.LogonUser.LogonUserName;
				drSpecimenTest[TABLE.SpecimenTest.RowVersion] = test.RowVersion;
				drSpecimenTest[TABLE.SpecimenTest.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
				dtSpecimenTest.Rows.Add(drSpecimenTest);
				//
				//BR_94.12
				if ((test.AboRHChangeIndicator)&&(dtPatient.Rows.Count==0))
				{
					DataRow drPatient = dtPatient.NewRow();
					drPatient[TABLE.Patient.PatientGuid] = patientGuid;
					drPatient[TABLE.Patient.AboRhChangeIndicator] = false;
					drPatient[TABLE.Patient.RowVersion] = patientRowVersion;
					dtPatient.Rows.Add(drPatient);
				}
				//
				if (((test.OrderedTest.OrderableTestId == (int)Common.OrderableTest.ABID)||
					(test.OrderedTest.OrderableTestId == (int)Common.OrderableTest.RepeatABID))&&
					(test.AntibodyType != null))
				{
					//BR_94.10 - Remove TRs if ABID invalidated
					DataRow[] drReq = dtTransfusionRequirements.Select(TABLE.PatientTransfusionRequirement.TransfusionRequirementCategoryCode+" = 'AS' AND "+
						TABLE.PatientTransfusionRequirement.RecordStatusCode+" = 'A' AND "+
						TABLE.PatientTransfusionRequirement.SpecimenTestGuid+" = '"+test.SpecimenTestGuid.ToString()+"' AND "+
						TABLE.PatientTransfusionRequirement.AntibodyTypeId+" = "+test.AntibodyType.AntibodyTypeId);
					//
					if ((drReq != null) && (drReq.Length>0))
					{
						foreach(DataRow dr in drReq)
						{
							DataRow drTransfusionReq = transfusionReqs.NewRow();
							//
							drTransfusionReq[TABLE.PatientTransfusionRequirement.PatientTransfusionRequirementGuid] = dr[TABLE.PatientTransfusionRequirement.PatientTransfusionRequirementGuid];
							drTransfusionReq[TABLE.PatientTransfusionRequirement.InactivationComment] = invalidateComment;
							drTransfusionReq[TABLE.PatientTransfusionRequirement.InactivateDate] = currentDateTime;
							drTransfusionReq[TABLE.PatientTransfusionRequirement.InactivateUser] = Common.LogonUser.LogonUserName;
							drTransfusionReq[TABLE.PatientTransfusionRequirement.InactivateDivisionCode] = Common.LogonUser.LogonUserDivisionCode;								
							drTransfusionReq[TABLE.PatientTransfusionRequirement.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Inactive);
							drTransfusionReq[TABLE.PatientTransfusionRequirement.RowVersion] = dr[TABLE.PatientTransfusionRequirement.RowVersion];
							drTransfusionReq[TABLE.PatientTransfusion.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
							//
							transfusionReqs.Rows.Add(drTransfusionReq);
						}
					}
				}
				//
				if (updateAntiseraOrderedTests == null)
				{
					//If this is part of a TAS, only look for AntiseraOrderedTest if invalidating the DAT part
					if ((test.BloodTestType.ReportableTestId == (int)Common.OrderableTest.DAT)||
						(test.BloodTestType.OrderableTestId != (int)Common.OrderableTest.TAS))
					{
						DataTable antiseraOrderedTests = DAL.OrderedTest.GetAntiseraOrderedTests(test.OrderedTest.OrderedTestGuid);
						if (antiseraOrderedTests.Rows.Count>0)
						{
							updateAntiseraOrderedTests = new DataTable(TABLE.AntiseraOrderedTest.TableName);
							updateAntiseraOrderedTests.Columns.Add(TABLE.AntiseraOrderedTest.AntiseraOrderedTestGuid, typeof(Guid));
							updateAntiseraOrderedTests.Columns.Add(TABLE.AntiseraOrderedTest.RecordStatusCode, typeof(char));
							updateAntiseraOrderedTests.Columns.Add(TABLE.AntiseraOrderedTest.RowVersion, typeof(byte[]));
							//
							foreach(DataRow dr in antiseraOrderedTests.Rows)
							{
								DataRow drUpdate = updateAntiseraOrderedTests.NewRow();
								drUpdate[TABLE.AntiseraOrderedTest.AntiseraOrderedTestGuid] = dr[TABLE.AntiseraOrderedTest.AntiseraOrderedTestGuid];
								drUpdate[TABLE.AntiseraOrderedTest.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Inactive);
								drUpdate[TABLE.AntiseraOrderedTest.RowVersion] = dr[TABLE.AntiseraOrderedTest.RowVersion];
								updateAntiseraOrderedTests.Rows.Add(drUpdate);
							}
						}
					}
				}
			}
			//BR_94.07, BR_94.08
			DataTable dtOrderedTest = null;
			if (replaceResults)
			{
				BOL.SpecimenTest test = (BOL.SpecimenTest)specimenTests[0];

				dtOrderedTest = new DataTable(TABLE.OrderedTest.TableName);
				dtOrderedTest.Columns.Add(TABLE.OrderedTest.OrderedTestGuid, typeof(Guid));
				dtOrderedTest.Columns.Add(TABLE.OrderedTest.PatientSpecimenGuid, typeof(Guid));
				dtOrderedTest.Columns.Add(TABLE.OrderedTest.OrderStatusCode, typeof(char));
				dtOrderedTest.Columns.Add(TABLE.OrderedTest.TaskStatusCode, typeof(char));
				dtOrderedTest.Columns.Add(TABLE.OrderedTest.CancellationCannedCommentGuid, typeof(Guid));
				dtOrderedTest.Columns.Add(TABLE.OrderedTest.RowVersion, typeof(byte[]));

				DataRow drOrderedTest = dtOrderedTest.NewRow();
				drOrderedTest[TABLE.OrderedTest.OrderedTestGuid] = test.OrderedTest.OrderedTestGuid;
				drOrderedTest[TABLE.OrderedTest.PatientSpecimenGuid] = test.OrderedTest.Specimen.SpecimenGuid;
				drOrderedTest[TABLE.OrderedTest.OrderStatusCode] = Common.Utility.GetOrderStatusCodeFromEnum(Common.OrderStatus.Accepted);
				drOrderedTest[TABLE.OrderedTest.TaskStatusCode] = Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.ResultsCorrected);
				drOrderedTest[TABLE.OrderedTest.CancellationCannedCommentGuid] = DBNull.Value;
				drOrderedTest[TABLE.OrderedTest.RowVersion] = test.OrderedTest.RowVersion;
				dtOrderedTest.Rows.Add(drOrderedTest);
			}
			Guid [] patientGuids = new Guid[1];
			patientGuids[0] = patientGuid;												
			for(int nCtr = 0; nCtr < alWorkloadProcessIds.Count; nCtr ++)
			{
				System.Data.DataTable dtWorkloadEventTemp = BOL.WorkloadEvent.GenerateWorkloadData((Common.WorkloadProcessID) alWorkloadProcessIds[nCtr], patientGuids, Common.WorkloadTransactionType.Patient, true);
				if(dtWorkloadEvent == null)
				{
					dtWorkloadEvent = dtWorkloadEventTemp.Clone();
				}
				foreach(System.Data.DataRow dtRow in dtWorkloadEventTemp.Rows)
				{
					DataRow dtNewRow = dtWorkloadEvent.NewRow();
					dtNewRow.ItemArray = dtRow.ItemArray;
					dtWorkloadEvent.Rows.Add(dtNewRow);
				}
			}
			//
			return DAL.SpecimenTest.InvalidateSpecimenTestResults(dtSpecimenTest,dtOrderedTest, dtWorkloadEvent, transfusionReqs, dtPatient, updateAntiseraOrderedTests,lastUpdateFunction);

		}
	}
}
